% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KM-specifications.R
\name{add_km_feature}
\alias{add_km_feature}
\title{Add KM feature specifications to an \link{MDB} object}
\usage{
add_km_feature(x, kmr, table, feature, fields, unit = as.character(NA))
}
\arguments{
\item{x}{an \link{MDB} object to update with specification tables}

\item{kmr}{an \link{MDB} object with KM requirements}

\item{table}{the name of an existing table in x}

\item{feature}{the name of an existing feature in kmr}

\item{fields}{Either a single character providing the name of an existing
field in table or a list named with feature property names from kmr. Each
element of the list should provide a "field" slot with the name of the
corresponding field and a "unit" slot with the name of the unit if relevant.}

\item{unit}{a single character providing the unit if relevant. Unit
information provided in fields override this parameter value.}
}
\value{
An \link{MDB} object with additional KM table feature specification
}
\description{
Add KM feature specifications to an \link{MDB} object
}
