% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TLIC.R
\name{TLIC}
\alias{TLIC}
\title{TLIC function based on LIC with T-distributed errors}
\usage{
TLIC(X, Y, alpha = 0.05, K = 10, nk = NULL, dist_type = "student_t")
}
\arguments{
\item{X}{is a design matrix}

\item{Y}{is a random response vector of observed values}

\item{alpha}{is the significance level}

\item{K}{is the number of subsets}

\item{nk}{is the sample size of subsets}

\item{dist_type}{Type of distribution for the error terms.}
}
\value{
MUopt, Bopt, MAEMUopt, MSEMUopt, opt, Yopt
}
\description{
TLIC function based on LIC with T-distributed errors
}
\examples{
set.seed(12)
n <- 1200
nr <- 200
p <- 5
data <- terr(n, nr, p, dist_type = "student_t")
TLIC(data$X, data$Y, alpha = 0.05, K = 10, nk = n / 10, dist_type = "student_t")

}
