% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tropical_logistic_regression.R
\name{trop.logistic.regression}
\alias{trop.logistic.regression}
\title{Tropical Logistic Regression}
\usage{
trop.logistic.regression(D, Y, penalty = 0, model_type = "two_species")
}
\arguments{
\item{D}{matrix of dimension N*e, where N is the number of observations which lie in R^e}

\item{Y}{binary vector with dimension N, with each component corresponding to an observation}

\item{penalty}{scalar; positive real number}

\item{model_type}{string; options are "two-species" (default),  "one-species", "general"}
}
\value{
vector; optimal model parameters (two normal vectors and two scaling factors)
}
\description{
Performs tropical logistic regression, by finding the optimal statistical parameters for the
training dataset (D,Y), where D is the matrix of covariates and Y is the binary response vector
}
\examples{
\donttest{
library(ROCR)
T0 = Sim_Trees15
T1 = Sim_Trees25
D  = rbind(T0,T1)
Y = c(rep(0,dim(T0)[1]), rep(1,dim(T1)[1]))
N = length(Y)
set.seed(1)
train_set = sample(N,floor(0.8 * N)) ## 80/20 train-test split
pars <- trop.logistic.regression(D[train_set,],Y[train_set], penalty=1e4)
test_set = (1:N)[-train_set]
Y.hat <- rep(0, length(test_set))
for(i in 1:length(test_set))   Y.hat[i] <- prob.class(pars, D[test_set[i],])
Logit.ROC <- performance(prediction(Y.hat, Y[test_set]), measure="tpr", x.measure="fpr")
plot(Logit.ROC, lwd = 2, main = "ROC Curve for Logistic Regression Model")
print(paste("Logit.AUC=", performance(prediction(Y.hat, Y[test_set]), measure="auc")@y.values))
}
}
\references{
Aliatimis, Georgios, Ruriko Yoshida, Burak Boyaci and James A. Grant (2023). Tropical Logistic Regression on Space of Phylogenetic Trees.
}
\author{
Georgios Aliatimis \email{g.aliatimis@lancaster.ac.uk}
}
