% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerTOSTone.R
\name{powerTOSTone}
\alias{powerTOSTone}
\title{Power analysis for TOST for one-sample t-test (Cohen's d)}
\usage{
powerTOSTone(alpha, statistical_power, low_eqbound_d, high_eqbound_d)
}
\arguments{
\item{alpha}{alpha used for the test (e.g., 0.05)}

\item{statistical_power}{desired power (e.g., 0.8)}

\item{low_eqbound_d}{lower equivalence bounds (e.g., -0.5) expressed in standardized mean difference (Cohen's d)}

\item{high_eqbound_d}{upper equivalence bounds (e.g., 0.5) expressed in standardized mean difference (Cohen's d)}
}
\value{
Returns a string summarizing the power analysis, and a numeric variable for the number of observations needed in each group
}
\description{
Power analysis for TOST for one-sample t-test (Cohen's d)
}
\section{References}{

Chow, S.-C., Wang, H., & Shao, J. (2007). Sample Size Calculations in Clinical Research, Second Edition - CRC Press Book. Formula 3.1.9
}
\examples{
## Sample size for alpha = 0.05, 90\% power, equivalence bounds of 
## Cohen's d = -0.3 and Cohen's d = 0.3, and assuming true effect = 0
powerTOSTone(alpha=0.05, statistical_power=0.9, low_eqbound_d=-0.3, high_eqbound_d=0.3)
}

