% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile_plot.R
\name{quantile_plot}
\alias{quantile_plot}
\title{Quantile plot for visualizing data distribution.}
\usage{
quantile_plot(
  data,
  my_shape = "fill_circle",
  point_size = 1.5,
  conf_int = TRUE,
  conf_level = 0.95,
  split_panel = "One_Panel",
  legend_pos = "right",
  legend_dir = "vertical",
  sci_fill_color = "Sci_AAAS",
  sci_color_alpha = 0.75,
  ggTheme = "theme_light"
)
}
\arguments{
\item{data}{Dataframe: include Value, Group columns.}

\item{my_shape}{Character: scatter shape. Default: "fill_circle", options: "border_square", "border_circle", "border_triangle", "plus", "times", "border_diamond", "border_triangle_down", "square_times", "plus_times", "diamond_plus", "circle_plus", "di_triangle", "square_plus", "circle_times","square_triangle", "fill_square", "fill_circle", "fill_triangle", "fill_diamond", "large_circle", "small_circle", "fill_border_circle", "fill_border_square", "fill_border_diamond", "fill_border_triangle".}

\item{point_size}{Numeric: point size. Default: 1.5, min: 0.0, max: not required.}

\item{conf_int}{Logical: confidence interval (CI). Default: TRUE, options: TRUE or FALSE.}

\item{conf_level}{Numeric: confidence interval value. Default: 0.95, min: 0.00, max: 1.00.}

\item{split_panel}{Character: split panel by groups. Default: "One_Panel", options: "One_Panel", "Split_Panel".}

\item{legend_pos}{Character: legend position. Default: "right", options: "none", "left", "right", "bottom", "top".}

\item{legend_dir}{Character: legend direction. Default: "vertical", options: "horizontal", "vertical".}

\item{sci_fill_color}{Character: ggsci fill or color palette. Default: "Sci_AAAS", options: "Sci_AAAS", "Sci_NPG", "Sci_Simpsons", "Sci_JAMA", "Sci_GSEA", "Sci_Lancet", "Sci_Futurama", "Sci_JCO", "Sci_NEJM", "Sci_IGV", "Sci_UCSC", "Sci_D3", "Sci_Material".}

\item{sci_color_alpha}{Numeric: ggsci border color alpha. Default: 0.75, min: 0.00, max: 1.00.}

\item{ggTheme}{Character: ggplot2 themes. Default: "theme_light", options: "theme_default", "theme_bw", "theme_gray", "theme_light", "theme_linedraw", "theme_dark", "theme_minimal", "theme_classic", "theme_void".}
}
\value{
Plot: quantile plot for visualizing data distribution.
}
\description{
Quantile plot for visualizing data distribution.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(quantile_data)

# 3. Default parameters
quantile_plot(quantile_data)

# 4. Set split_panel = "Split_Panel"
quantile_plot(quantile_data, split_panel = "Split_Panel")

# 5. Set sci_fill_color = "Sci_Futurama"
quantile_plot(quantile_data, sci_fill_color = "Sci_Futurama")

# 6. Set conf_int = FALSE
quantile_plot(quantile_data, conf_int = FALSE)

}
\author{
benben-miao
}
