% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_plot.R
\name{network_plot}
\alias{network_plot}
\title{Network plot for analyzing and visualizing relationship of genes.}
\usage{
network_plot(
  data,
  calcBy = "degree",
  degreeValue = 0.05,
  nodeColorNormal = "#00888888",
  nodeBorderColor = "#FFFFFF",
  nodeColorFrom = "#FF000088",
  nodeColorTo = "#00880088",
  nodeShapeNormal = "circle",
  nodeShapeSpatial = "csquare",
  nodeSize = 10,
  labelSize = 0.5,
  edgeCurved = TRUE,
  netLayout = "layout_on_sphere"
)
}
\arguments{
\item{data}{Dataframe: include columns (source_node, target_node).}

\item{calcBy}{Character: calculate relationship by "degree", "node". Default: "degree".}

\item{degreeValue}{Numeric: degree value when calcBy = "degree". Default: 0.05, min: 0.00, max: 1.00.}

\item{nodeColorNormal}{Character: normal relationship nodes color (color name of hex value).}

\item{nodeBorderColor}{Character: node border color (color name or hex value).}

\item{nodeColorFrom}{Character: the start color of nodes that meet degreeValue.}

\item{nodeColorTo}{Character: the end color of nodes that meet degreeValue.}

\item{nodeShapeNormal}{Character: normal node shape. Default: "circle", options: "circle", "crectangle", "csquare", "none", "pie", "raster", "rectangle", "sphere", "square", "vrectangle".}

\item{nodeShapeSpatial}{Character: meet degreeValue node shape. Default: "csquare", options: "circle", "crectangle", "csquare", "none", "pie", "raster", "rectangle", "sphere", "square", "vrectangle".}

\item{nodeSize}{Numeric: node size. Default: 10, min: 0, max: NULL.}

\item{labelSize}{Numeric: node label size. Default: 0.5, min: 0, max: NULL.}

\item{edgeCurved}{Logical: curved edges. Default: TRUE, options: TRUE, FALSE.}

\item{netLayout}{Character: network layout. Default: "layout_on_sphere", options: "layout_as_bipartite", "layout_as_star", "layout_as_tree", "layout_components", "layout_in_circle", "layout_nicely", "layout_on_grid", "layout_on_sphere","layout_randomly","layout_with_dh","layout_with_drl","layout_with_fr","layout_with_gem","layout_with_graphopt","layout_with_kk","layout_with_lgl","layout_with_mds","layout_with_sugiyama".}
}
\value{
Plot: network plot for analyzing and visualizing relationship of genes.
}
\description{
Network plot for analyzing and visualizing relationship of genes.
}
\examples{
# 1. Library TOmicsVis package
library(TOmicsVis)

# 2. Use example dataset
data(network_data)
head(network_data)

# 3. Default parameters
network_plot(network_data)

# 4. Set calcBy = "node"
network_plot(network_data, calcBy = "node")

# 5. Set degreeValue = 0.1
network_plot(network_data, degreeValue = 0.1)

# 6. Set nodeColorNormal = "#00888833"
network_plot(network_data, nodeColorNormal = "#00888833")

# 7. Set labelSize = 0
network_plot(network_data, labelSize = 0)

}
\author{
benben-miao
}
