% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PBtRED2.R
\name{PBtRED2}
\alias{PBtRED2}
\title{Partially Balanced Ternary Residual Effect Designs for a Prime Number of Treatments, v (>=5); Series 1: v = 4m + 1, Series 2: v = 4m + 3 and Series 3: v = 6m + 1}
\usage{
PBtRED2(m, series)
}
\arguments{
\item{m}{Any number (>= 1) such that v (>=5) is prime.}

\item{series}{Choose series: 1, 2 or 3}
}
\value{
It returns the a new class of PBTREDs based on chosen m along with its parameters, Information matrix (C), Average Variance Factor (AVF), and Canonical Efficiency Factor (CEF) for both treatment and residual effects.
}
\description{
This function generates three series of partially balanced ternary residual effect designs (PBTREDs) for a prime number of treatments (v), where (v >= 5) with p periods, and n sequences.

Parameters of Series 1: v = 4m+ 1, t = m, n = m(4m+ 1), p = 5, r = 5m

Parameters of Series 2: v = 4m+ 3, t = 2, n = 2(4m+ 3), p = 2(m+1), r = 4(m+1)

Parameters of Series 3: v = 6m+ 1, t = m, n = m(6m+1), p = 7, r =7m
}
\examples{
library(TREDesigns)
PBtRED2(m = 1, series=1)
}
