% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{getperform}
\alias{getperform}
\title{Get performance metrics for classification}
\usage{
getperform(
  ytest,
  ypretest,
  family,
  threshold.method = c("youden", "specificity.control", "quantile"),
  specificity = NULL
)
}
\arguments{
\item{ytest}{Response vector for test data.}

\item{ypretest}{Predicted probability for test data.}

\item{family}{"ls" or "logic". Return MSE when "ls" is used.}

\item{threshold.method}{Method to get the threshold.}

\item{specificity}{User-defined specificity or quantile.}
}
\value{
List of measures.
\item{AUC}{Area under the ROC curve.}
\item{AUPRC}{Area under the precision-recall curve.}
\item{threshold}{Selected threshold of the probability.}
\item{sensitivity}{Sensitivity with the selected threshold.}
\item{ppv}{Positive predictive value with the selected threshold.}
\item{specificity}{Specificity with the selected threshold.}
\item{true.positive}{Number of true positive with the selected threshold.}
\item{false.positive}{Number of false positive with the selected threshold.}
}
\description{
Evaluate the prediction performance under the classification settings.
}
\details{
The function supports three methods to select the threshold of the
predicted probability.

\code{threshold.method = "youden"}: The optimal threshold corresponds to
the point that maximizes the distance to the identity (diagonal) line on
the ROC curve.

\code{threshold.method = "specificity.control"}: The optimal threshold
corresponds to the smallest value that ensures the required specificity
value.

\code{threshold.method = "quantile"}: The optimal threshold corresponds to
the required quantile of the predicted probability.
}
