# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @rdname clipping
#' @name clipping
#' @title Creates bit-level (clipped representation) from a vector
#'
#' @description The \code{clipping} computes bit-level (clipped representation) from a vector.
#'
#' @return the integer vector of zeros and ones
#'
#' @param x the numeric vector (time series)
#'
#' @details Clipping transforms time series to bit-level representation.
#'
#' It is defined as follows:
#' \deqn{repr_t   =   {1   if   x_t   >   \mu ,  0  otherwise,}}{repr_t  =   {1   if   x_t   >   \mu ,  0   otherwise,}} where \eqn{x_t} is a value of a time series
#' and \eqn{\mu} is average of a time series.
#'
#' @seealso \code{\link[TSrepr]{trending}}
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @references Bagnall A, Ratanamahatana C, Keogh E, Lonardi S, Janacek G (2006)
#' A bit level representation for time series data mining with shape based similarity.
#' Data Mining and Knowledge Discovery 13(1):11-40
#'
#' Laurinec P, and Lucka M (2018)
#' Interpretable multiple data streams clustering with clipped streams representation for the improvement of electricity consumption forecasting.
#' Data Mining and Knowledge Discovery. Springer. DOI: 10.1007/s10618-018-0598-2
#'
#' @importFrom Rcpp evalCpp
#'
#' @examples
#' clipping(rnorm(50))
#'
#' @useDynLib TSrepr
#' @export clipping
clipping <- function(x) {
    .Call('_TSrepr_clipping', PACKAGE = 'TSrepr', x)
}

#' @rdname trending
#' @name trending
#' @title Creates bit-level (trending) representation from a vector
#'
#' @description The \code{trending} Computes bit-level (trending) representation from a vector.
#'
#' @return the integer vector of zeros and ones
#'
#' @param x the numeric vector (time series)
#'
#' @details Trending transforms time series to bit-level representation.
#'
#' It is defined as follows:
#' \deqn{repr_t   =   {1   if   x_t  -  x_{t+1}  <  0 ,  0   otherwise,}}{repr_t   =   {1   if   x_t  -  x_{t+1}  <  0 ,  0   otherwise,}}
#' where \eqn{x_t} is a value of a time series.
#'
#' @seealso \code{\link[TSrepr]{clipping}}
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @examples
#' trending(rnorm(50))
#'
#' @useDynLib TSrepr
#' @export trending
trending <- function(x) {
    .Call('_TSrepr_trending', PACKAGE = 'TSrepr', x)
}

#' @rdname repr_feaclip
#' @name repr_feaclip
#' @title FeaClip representation of time series
#'
#' @description The \code{repr_feaclip} computes representation of time series based on feature extraction from bit-level (clipped) representation.
#'
#' @return the numeric vector of length 8
#'
#' @param x the numeric vector (time series)
#'
#' @details FeaClip is method of time series representation based on feature extraction from run lengths (RLE) of bit-level (clipped) representation.
#' It extracts 8 key features from clipped representation.
#'
#' There are as follows: \deqn{repr   =  \{  max_1  -  max.  from  run  lengths  of  ones,}
#' \deqn{sum_1 -  sum  of  run  lengths  of  ones,}
#' \deqn{max_0  -  max.  from  run  lengths  of  zeros,}
#' \deqn{crossings  -  length  of  RLE  encoding  -  1,}
#' \deqn{f_0  -  number  of   first  zeros,}
#' \deqn{l_0  -  number  of  last  zeros,}
#' \deqn{f_1  -  number  of  first  ones,}
#' \deqn{l_1  -  number  of  last  ones  \}  .}
#'
#' @seealso \code{\link[TSrepr]{repr_featrend}, \link[TSrepr]{repr_feacliptrend}}
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @references Laurinec P, and Lucka M (2018)
#' Interpretable multiple data streams clustering with clipped streams representation for the improvement of electricity consumption forecasting.
#' Data Mining and Knowledge Discovery. Springer. DOI: 10.1007/s10618-018-0598-2
#'
#' @examples
#' repr_feaclip(rnorm(50))
#'
#' @useDynLib TSrepr
#' @export repr_feaclip
repr_feaclip <- function(x) {
    .Call('_TSrepr_repr_feaclip', PACKAGE = 'TSrepr', x)
}

#' @rdname repr_featrend
#' @name repr_featrend
#' @title FeaTrend representation of time series
#'
#' @description The \code{repr_featrend} computes representation of time series based on feature extraction from bit-level (trending) representation.
#'
#' @return the numeric vector of the length pieces
#'
#' @param x the numeric vector (time series)
#' @param func the function of aggregation, can be sumC or maxC or similar aggregation function
#' @param pieces the number of parts of time series to split (default to 2)
#' @param order the order of simple moving average (default to 4)
#'
#' @details FeaTrend is method of time series representation based on feature extraction from run lengths (RLE) of bit-level (trending) representation.
#' It extracts number of features from trending representation based on number of pieces defined.
#' From every piece, 2 features are extracted. You can define what feature will be extracted,
#' recommended functions are max and sum. For example if max is selected, then maximum value of run lengths of ones and zeros are extracted.
#'
#' @seealso \code{\link[TSrepr]{repr_feaclip}, \link[TSrepr]{repr_feacliptrend}}
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @examples
#' # default settings
#' repr_featrend(rnorm(50), maxC)
#'
#' # compute FeaTrend for 4 pieces and make more smoothed ts by order = 8
#' repr_featrend(rnorm(50), sumC, 4, 8)
#'
#' @useDynLib TSrepr
#' @export repr_featrend
repr_featrend <- function(x, func, pieces = 2L, order = 4L) {
    .Call('_TSrepr_repr_featrend', PACKAGE = 'TSrepr', x, func, pieces, order)
}

#' @rdname repr_feacliptrend
#' @name repr_feacliptrend
#' @title FeaClipTrend representation of time series
#'
#' @description The \code{repr_feacliptrend} computes representation of time series
#' based on feature extraction from bit-level representations (clipping and trending).
#'
#' @return the numeric vector of frequencies of features
#'
#' @param x the numeric vector (time series)
#' @param func the aggregation function for FeaTrend procedure (sumC or maxC)
#' @param pieces the number of parts of time series to split
#' @param order the order of simple moving average
#'
#' @details FeaClipTrend combines FeaClip and FeaTrend representation methods.
#' See documentation of these two methods (check See Also section).
#'
#' @seealso \code{\link[TSrepr]{repr_featrend}, \link[TSrepr]{repr_feaclip}}
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @references Laurinec P, and Lucka M (2018)
#' Interpretable multiple data streams clustering with clipped streams representation for the improvement of electricity consumption forecasting.
#' Data Mining and Knowledge Discovery. Springer. DOI: 10.1007/s10618-018-0598-2
#'
#' @examples
#' repr_feacliptrend(rnorm(50), maxC, 2, 4)
#'
#' @useDynLib TSrepr
#' @export repr_feacliptrend
repr_feacliptrend <- function(x, func, pieces = 2L, order = 4L) {
    .Call('_TSrepr_repr_feacliptrend', PACKAGE = 'TSrepr', x, func, pieces, order)
}

#' @rdname fast_stat
#' @name fast_stat
#' @title Fast statistic functions (helpers)
#'
#' @description Fast statistic functions (helpers) for representations computation.
#'
#' @return the numeric value
#'
#' @param x the numeric vector
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @examples
#' maxC(rnorm(50))
#'
#' @useDynLib TSrepr
#' @export maxC
maxC <- function(x) {
    .Call('_TSrepr_maxC', PACKAGE = 'TSrepr', x)
}

#' @rdname fast_stat
#' @name fast_stat
#' @title Fast statistic functions (helpers)
#'
#' @examples
#' minC(rnorm(50))
#'
#' @export minC
minC <- function(x) {
    .Call('_TSrepr_minC', PACKAGE = 'TSrepr', x)
}

#' @rdname fast_stat
#' @name fast_stat
#' @title Fast statistic functions (helpers)
#'
#' @examples
#' meanC(rnorm(50))
#'
#' @useDynLib TSrepr
#' @export meanC
meanC <- function(x) {
    .Call('_TSrepr_meanC', PACKAGE = 'TSrepr', x)
}

#' @rdname fast_stat
#' @name fast_stat
#' @title Fast statistic functions (helpers)
#'
#' @examples
#' sumC(rnorm(50))
#'
#' @useDynLib TSrepr
#' @export sumC
sumC <- function(x) {
    .Call('_TSrepr_sumC', PACKAGE = 'TSrepr', x)
}

#' @rdname fast_stat
#' @name fast_stat
#' @title Fast statistic functions (helpers)
#'
#' @examples
#' medianC(rnorm(50))
#'
#' @useDynLib TSrepr
#' @export medianC
medianC <- function(x) {
    .Call('_TSrepr_medianC', PACKAGE = 'TSrepr', x)
}

#' @rdname mse
#' @name mse
#' @title MSE
#'
#' @description The \code{mse} computes MSE (Mean Squared Error) of a forecast.
#'
#' @return the numeric value
#'
#' @param x the numeric vector of real values
#' @param y the numeric vector of forecasted values
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @examples
#' mse(runif(50), runif(50))
#'
#' @useDynLib TSrepr
#' @export mse
mse <- function(x, y) {
    .Call('_TSrepr_mse', PACKAGE = 'TSrepr', x, y)
}

#' @rdname rmse
#' @name rmse
#' @title RMSE
#'
#' @description The \code{rmse} computes RMSE (Root Mean Squared Error) of a forecast.
#'
#' @return the numeric value
#'
#' @param x the numeric vector of real values
#' @param y the numeric vector of forecasted values
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @examples
#' rmse(runif(50), runif(50))
#'
#' @useDynLib TSrepr
#' @export rmse
rmse <- function(x, y) {
    .Call('_TSrepr_rmse', PACKAGE = 'TSrepr', x, y)
}

#' @rdname mae
#' @name mae
#' @title MAE
#'
#' @description The \code{mae} computes MAE (Mean Absolute Error) of a forecast.
#'
#' @return the numeric value
#'
#' @param x the numeric vector of real values
#' @param y the numeric vector of forecasted values
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @examples
#' mae(runif(50), runif(50))
#'
#' @useDynLib TSrepr
#' @export mae
mae <- function(x, y) {
    .Call('_TSrepr_mae', PACKAGE = 'TSrepr', x, y)
}

#' @rdname mdae
#' @name mdae
#' @title MdAE
#'
#' @description The \code{mdae} computes MdAE (Median Absolute Error) of a forecast.
#'
#' @return the numeric value
#'
#' @param x the numeric vector of real values
#' @param y the numeric vector of forecasted values
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @examples
#' mdae(runif(50), runif(50))
#'
#' @useDynLib TSrepr
#' @export mdae
mdae <- function(x, y) {
    .Call('_TSrepr_mdae', PACKAGE = 'TSrepr', x, y)
}

#' @rdname smape
#' @name smape
#' @title sMAPE
#'
#' @description The \code{smape} computes sMAPE (Symmetric Mean Absolute Percentage Error) of a forecast.
#'
#' @return the numeric value in \%
#'
#' @param x the numeric vector of real values
#' @param y the numeric vector of forecasted values
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @examples
#' smape(runif(50), runif(50))
#'
#' @useDynLib TSrepr
#' @export smape
smape <- function(x, y) {
    .Call('_TSrepr_smape', PACKAGE = 'TSrepr', x, y)
}

#' @rdname mape
#' @name mape
#' @title MAPE
#'
#' @description the \code{mape} computes MAPE (Mean Absolute Percentage Error) of a forecast.
#'
#' @return the numeric value in \%
#'
#' @param x the numeric vector of real values
#' @param y the numeric vector of forecasted values
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @examples
#' mape(runif(50), runif(50))
#'
#' @useDynLib TSrepr
#' @export mape
mape <- function(x, y) {
    .Call('_TSrepr_mape', PACKAGE = 'TSrepr', x, y)
}

#' @rdname maape
#' @name maape
#' @title MAAPE
#'
#' @description the \code{maape} computes MAAPE (Mean Arctangent Absolute Percentage Error) of a forecast.
#'
#' @return the numeric value in \%
#'
#' @param x the numeric vector of real values
#' @param y the numeric vector of forecasted values
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @references Sungil Kim, Heeyoung Kim (2016)
#' A new metric of absolute percentage error for intermittent demand forecasts,
#'  International Journal of Forecasting 32(3):669-679
#'
#' @examples
#' maape(runif(50), runif(50))
#'
#' @useDynLib TSrepr
#' @export maape
maape <- function(x, y) {
    .Call('_TSrepr_maape', PACKAGE = 'TSrepr', x, y)
}

#' @rdname mase
#' @name mase
#' @title MASE
#'
#' @description The \code{mase} computes MASE (Mean Absolute Scaled Error) of a forecast.
#'
#' @return the numeric value
#'
#' @param real the numeric vector of real values
#' @param forecast the numeric vector of forecasted values
#' @param naive the numeric vector of naive forecast
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @examples
#' mase(rnorm(50), rnorm(50), rnorm(50))
#'
#' @useDynLib TSrepr
#' @export mase
mase <- function(real, forecast, naive) {
    .Call('_TSrepr_mase', PACKAGE = 'TSrepr', real, forecast, naive)
}

#' @rdname norm_z
#' @name norm_z
#' @title Z-score normalisation
#'
#' @description The \code{norm_z} normalises time series by z-score.
#'
#' @return the numeric vector of normalised values
#'
#' @seealso \code{\link[TSrepr]{norm_min_max}}
#'
#' @param x the numeric vector (time series)
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @examples
#' norm_z(runif(50))
#'
#' @useDynLib TSrepr
#' @export norm_z
norm_z <- function(x) {
    .Call('_TSrepr_norm_z', PACKAGE = 'TSrepr', x)
}

#' @rdname norm_z_list
#' @name norm_z_list
#' @title Z-score normalization list
#'
#' @description The \code{norm_z_list} normalizes time series by z-score and returns normalization parameters (mean and standard deviation).
#'
#' @return the list composed of:
#'  \describe{
#'  \item{\strong{norm_values}}{the numeric vector of normalised values of time series}
#'  \item{\strong{mean}}{the mean value}
#'  \item{\strong{sd}}{the standard deviation}
#'   }
#'
#' @param x the numeric vector (time series)
#'
#' @seealso \code{\link[TSrepr]{norm_min_max_list}}
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @examples
#' norm_z_list(runif(50))
#'
#' @useDynLib TSrepr
#' @export norm_z_list
norm_z_list <- function(x) {
    .Call('_TSrepr_norm_z_list', PACKAGE = 'TSrepr', x)
}

#' @rdname denorm_z
#' @name denorm_z
#' @title Z-score denormalisation
#'
#' @description The \code{denorm_z} denormalises time series by z-score method.
#'
#' @return the numeric vector of denormalised values
#'
#' @param x the numeric vector (time series)
#' @param mean the mean value
#' @param sd the standard deviation value
#'
#' @seealso \code{\link[TSrepr]{norm_z}, \link[TSrepr]{norm_z_list}}
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @references Laurinec P, Lucká M (2018)
#' Clustering-based forecasting method for individual consumers electricity load using time series representations.
#' Open Comput Sci, 8(1):38–50, DOI: 10.1515/comp-2018-0006
#'
#' @examples
#' # Normalise values and save normalisation parameters:
#' norm_res <- norm_z_list(rnorm(50, 5, 2))
#' # Denormalise new data with previous computed parameters:
#' denorm_z(rnorm(50, 4, 2), mean = norm_res$mean, sd = norm_res$sd)
#'
#' @useDynLib TSrepr
#' @export denorm_z
denorm_z <- function(x, mean, sd) {
    .Call('_TSrepr_denorm_z', PACKAGE = 'TSrepr', x, mean, sd)
}

#' @rdname norm_z_params
#' @name norm_z_params
#' @title Z-score normalisation with parameters
#'
#' @description The \code{norm_z_params} normalises time series by z-score with defined mean and standard deviation.
#'
#' @return the numeric vector of normalised values
#'
#' @seealso \code{\link[TSrepr]{norm_min_max_params}}
#'
#' @param x the numeric vector (time series)
#' @param mean the numeric value
#' @param sd the numeric value - standard deviation
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @examples
#' norm_z_params(runif(50), 0.5, 1)
#'
#' @useDynLib TSrepr
#' @export norm_z_params
norm_z_params <- function(x, mean, sd) {
    .Call('_TSrepr_norm_z_params', PACKAGE = 'TSrepr', x, mean, sd)
}

#' @rdname norm_min_max
#' @name norm_min_max
#' @title Min-Max normalisation
#'
#' @description The \code{norm_min_max} normalises time series by min-max method.
#'
#' @return the numeric vector of normalised values
#'
#' @param x the numeric vector (time series)
#'
#' @seealso \code{\link[TSrepr]{norm_z}}
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @examples
#' norm_min_max(rnorm(50))
#'
#' @useDynLib TSrepr
#' @export norm_min_max
norm_min_max <- function(x) {
    .Call('_TSrepr_norm_min_max', PACKAGE = 'TSrepr', x)
}

#' @rdname norm_min_max_list
#' @name norm_min_max_list
#' @title Min-Max normalization list
#'
#' @description The \code{norm_min_max_list} normalises time series by min-max method and returns normalization parameters (min and max).
#'
#' @return the list composed of:
#'  \describe{
#'  \item{\strong{norm_values}}{the numeric vector of normalised values of time series}
#'  \item{\strong{min}}{the min value}
#'  \item{\strong{max}}{the max value}
#'   }
#'
#' @param x the numeric vector (time series)
#'
#' @seealso \code{\link[TSrepr]{norm_z_list}}
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @examples
#' norm_min_max_list(rnorm(50))
#'
#' @useDynLib TSrepr
#' @export norm_min_max_list
norm_min_max_list <- function(x) {
    .Call('_TSrepr_norm_min_max_list', PACKAGE = 'TSrepr', x)
}

#' @rdname denorm_min_max
#' @name denorm_min_max
#' @title Min-Max denormalisation
#'
#' @description The \code{denorm_min_max} denormalises time series by min-max method.
#'
#' @return the numeric vector of denormalised values
#'
#' @param x the numeric vector (time series)
#' @param min the minimum value
#' @param max the maximal value
#'
#' @seealso \code{\link[TSrepr]{norm_min_max}, \link[TSrepr]{norm_min_max_list}}
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @references Laurinec P, Lucká M (2018)
#' Clustering-based forecasting method for individual consumers electricity load using time series representations.
#' Open Comput Sci, 8(1):38–50, DOI: 10.1515/comp-2018-0006
#'
#' @examples
#' # Normalise values and save normalisation parameters:
#' norm_res <- norm_min_max_list(rnorm(50, 5, 2))
#' # Denormalise new data with previous computed parameters:
#' denorm_min_max(rnorm(50, 4, 2), min = norm_res$min, max = norm_res$max)
#'
#' @useDynLib TSrepr
#' @export denorm_min_max
denorm_min_max <- function(x, min, max) {
    .Call('_TSrepr_denorm_min_max', PACKAGE = 'TSrepr', x, min, max)
}

#' @rdname norm_min_max_params
#' @name norm_min_max_params
#' @title Min-Max normalisation with parameters
#'
#' @description The \code{norm_min_max_params} normalises time series by min-max method with defined parameters.
#'
#' @return the numeric vector of normalised values
#'
#' @param x the numeric vector (time series)
#' @param min the numeric value
#' @param max the numeric value
#'
#' @seealso \code{\link[TSrepr]{norm_z_params}}
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @examples
#' norm_min_max_params(rnorm(50), 0, 1)
#'
#' @useDynLib TSrepr
#' @export norm_min_max_params
norm_min_max_params <- function(x, min, max) {
    .Call('_TSrepr_norm_min_max_params', PACKAGE = 'TSrepr', x, min, max)
}

#' @rdname repr_sma
#' @name repr_sma
#' @title Simple Moving Average representation
#'
#' @description The \code{repr_sma} computes Simple Moving Average (SMA) from a time series.
#'
#' @return the numeric vector of smoothed values
#'
#' @param x the numeric vector (time series)
#' @param order the order of simple moving average
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @examples
#' repr_sma(rnorm(50), 4)
#'
#' @useDynLib TSrepr
#' @export repr_sma
repr_sma <- function(x, order) {
    .Call('_TSrepr_repr_sma', PACKAGE = 'TSrepr', x, order)
}

#' @rdname repr_paa
#' @name repr_paa
#' @title PAA - Piecewise Aggregate Approximation
#'
#' @description The \code{repr_paa} computes PAA representation from a vector.
#'
#' @return the numeric vector
#'
#' @param x the numeric vector (time series)
#' @param q the integer of the length of the "piece"
#' @param func the aggregation function. Can be meanC, medianC, sumC, minC or maxC or similar aggregation function
#'
#' @details PAA with possibility to use arbitrary aggregation function.
#' The original method uses average as aggregation function.
#'
#' @seealso \code{\link[TSrepr]{repr_dwt}, \link[TSrepr]{repr_dft}, \link[TSrepr]{repr_dct}, \link[TSrepr]{repr_sma}}
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @references Keogh E, Chakrabarti K, Pazzani M, Mehrotra Sh (2001)
#' Dimensionality Reduction for Fast Similarity Search in Large Time Series Databases.
#' Knowledge and Information Systems 3(3):263-286
#'
#' @examples
#' repr_paa(rnorm(11), 2, meanC)
#'
#' @useDynLib TSrepr
#' @export repr_paa
repr_paa <- function(x, q, func) {
    .Call('_TSrepr_repr_paa', PACKAGE = 'TSrepr', x, q, func)
}

#' @rdname repr_seas_profile
#' @name repr_seas_profile
#' @title Mean seasonal profile of time series
#'
#' @description The \code{repr_seas_profile} computes mean seasonal profile representation from a time series.
#'
#' @return the numeric vector
#'
#' @param x the numeric vector (time series)
#' @param freq the integer of the length of the season
#' @param func the aggregation function. Can be meanC or medianC or similar aggregation function.
#'
#' @details This function computes mean seasonal profile representation for a seasonal time series.
#' The length of representation is length of set seasonality (frequency) of a time series.
#' Aggregation function is arbitrary (best choice is for you maybe mean or median).
#'
#' @author Peter Laurinec, <tsreprpackage@gmail.com>
#'
#' @references Laurinec P, Lucka M (2016)
#' Comparison of representations of time series for clustering smart meter data.
#' In: Lecture Notes in Engineering and Computer Science: Proceedings of The World Congress on Engineering and Computer Science 2016, pp 458-463
#'
#' Laurinec P, Loderer M, Vrablecova P, Lucka M, Rozinajova V, Ezzeddine AB (2016)
#' Adaptive time series forecasting of energy consumption using optimized cluster analysis.
#' In: Data Mining Workshops (ICDMW), 2016 IEEE 16th International Conference on, IEEE, pp 398-405
#'
#' Laurinec P, Lucká M (2018)
#' Clustering-based forecasting method for individual consumers electricity load using time series representations.
#' Open Comput Sci, 8(1):38–50, DOI: 10.1515/comp-2018-0006
#'
#' @seealso \code{\link[TSrepr]{repr_lm}, \link[TSrepr]{repr_gam}, \link[TSrepr]{repr_exp}}
#'
#' @examples
#' repr_seas_profile(rnorm(48*10), 48, meanC)
#'
#' @useDynLib TSrepr
#' @export repr_seas_profile
repr_seas_profile <- function(x, freq, func) {
    .Call('_TSrepr_repr_seas_profile', PACKAGE = 'TSrepr', x, freq, func)
}

#' @rdname rleC
#' @name rleC
#' @title RLE (Run Length Encoding) written in C++
#'
#' @description The \code{rleC} computes RLE from bit-level (clipping or trending representation) vector.
#'
#' @return the list of values and counts of zeros and ones
#'
#' @param x the integer vector (from \code{clipping} or \code{trending})
#'
#' @examples
#' # clipping
#' clipped <- clipping(rnorm(50))
#' rleC(clipped)
#' # trending
#' trended <- trending(rnorm(50))
#' rleC(trended)
#'
#' @useDynLib TSrepr
#' @export rleC
rleC <- function(x) {
    .Call('_TSrepr_rleC', PACKAGE = 'TSrepr', x)
}

