% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nondata_adaptive_repr.R
\name{repr_dft}
\alias{repr_dft}
\title{DFT representation by FFT}
\usage{
repr_dft(x, coef = 10)
}
\arguments{
\item{x}{the numeric vector (time series)}

\item{coef}{the number of coefficients to extract from FFT}
}
\value{
the numeric vector of DFT coefficients
}
\description{
The \code{repr_dft} computes DFT (Discrete Fourier Transform) representation from a time series by FFT (Fast Fourier Transform).
}
\details{
The length of the final time series representation is equal to set \code{coef} parameter.
}
\examples{
repr_dft(rnorm(50), coef = 4)

}
\seealso{
\code{\link[TSrepr]{repr_dwt}, \link[TSrepr]{repr_dct}, \link[stats]{fft}}
}
\author{
Peter Laurinec, <tsreprpackage@gmail.com>
}
