% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_functions.R
\name{train_model}
\alias{train_model}
\title{Train, Test, Evaluate, and Forecast Multiple Time Series Forecasting Models}
\usage{
train_model(input, methods, train_method, horizon, error = "MAPE",
  xreg = NULL, level = c(80, 95))
}
\arguments{
\item{input}{A univariate time series object (ts class)}

\item{methods}{A list, defines the models to use for training and forecasting the series. 
The list must include a sub list with the model type, and the model's arguments (when applicable) and notes about the model. 
The sub-list name will be used as the model ID. Possible models:

\code{\link[stats]{arima}} - model from the stats package 

\code{\link[forecast]{auto.arima}} - model from the forecast package

\code{\link[forecast]{ets}} - model from the forecast package

 \code{\link[stats]{HoltWinters}} - model from the stats package 

\code{\link[forecast]{nnetar}} - model from the forecast package

\code{\link[forecast]{tslm}} - model from the forecast package (note that the 'tslm' model must have the formula argument in the 'method_arg' argument)}

\item{train_method}{A list, defines the backtesting parameters:

partitions - an integer, set the number of training and testing partitions to be used in the backtesting process, 
where when partition is set to 1 it is a simple holdout training approach
 
space - an integer, defines the length of the backtesting window expansion
 
sample.in - an integer, optional, defines the length of the training partitions, and therefore the backtesting window structure. 
By default, it set to NULL and therefore, the backtesting using expending window. 
Otherwise, when the sample.in defined, the window structure is sliding
 
sample.in - an integer, optional, defines the length of the training partitions, and therefore the type of the backtesting window. 
By default, is set to NULL, which implay that the backtesting is using an expending window. Otherwise, when defining the size of the training partition, th
defines the train approach, either using a single testing partition (sample out) 
or use multiple testing partitions (backtesting). The list should include the training method argument, (please see 'details' for the structure of the argument)}

\item{horizon}{An integer, defines the forecast horizon}

\item{error}{A character, defines the error metrics to be used to sort the models leaderboard. Possible metric - "MAPE" or "RMSE"}

\item{xreg}{Optional, a list with two vectors (e.g., data.frame or matrix) of external regressors, 
one vector corresponding to the input series and second to the forecast itself 
(e.g., must have the same length as the input and forecast horizon, respectively)}

\item{level}{An integer, set the  confidence level of the prediction intervals}
}
\description{
Method for train test and compare multiple time series models using either one partition (i.e., sample out) 
or multipe partitions (backtesting)
}
\examples{
 \dontrun{
# Defining the models and their arguments
methods <- list(ets1 = list(method = "ets",
                            method_arg = list(opt.crit = "lik"),
                            notes = "ETS model with opt.crit = lik"),
                ets2 = list(method = "ets",
                            method_arg = list(opt.crit = "amse"),
                            notes = "ETS model with opt.crit = amse"),
                arima1 = list(method = "arima",
                              method_arg = list(order = c(2,1,0)),
                              notes = "ARIMA(2,1,0)"),
                arima2 = list(method = "arima",
                              method_arg = list(order = c(2,1,2),
                                                seasonal = list(order = c(1,1,1))),
                              notes = "SARIMA(2,1,2)(1,1,1)"),
                hw = list(method = "HoltWinters",
                          method_arg = NULL,
                          notes = "HoltWinters Model"),
                tslm = list(method = "tslm",
                            method_arg = list(formula = input ~ trend + season),
                            notes = "tslm model with trend and seasonal components"))
# Training the models with backtesting
md <- train_model(input = USgas,
                  methods = methods,
                  train_method = list(partitions = 4, 
                                      sample.out = 12, 
                                      space = 3),
                  horizon = 12,
                  error = "MAPE")
# View the model performance on the backtesting partitions
md$leaderboard
}
}
