% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapley.R
\name{shapley}
\alias{shapley}
\title{Shapley value}
\usage{
shapley(characteristic_func, method = "exact", n_rep = 10000, n_players = 0)
}
\arguments{
\item{characteristic_func}{The valued function defined on the subsets of the number
of players.}

\item{method}{Method used to calculate the Shapley value. Valid methods are:
\code{exact} for the exact calculation or \code{appro} for approximated polynomial
calculation based on sampling.}

\item{n_rep}{Only used if \code{method} is \code{appro}. The number of
iterations to perform in the approximated calculation.}

\item{n_players}{Only used if \code{characteristic_func} is a \code{function}.
The number of players in the game.}
}
\value{
The Shapley value for each player.
}
\description{
Calculate the Shapley value
}
\examples{
n <- 3
v <- c(1,1,2,1,2,2,2)
shapley(v, method = "exact")
shapley(v, method = "appro", n_rep = 4000)

}
