% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_function.R
\name{localPCA}
\alias{localPCA}
\title{Perform Local PCA Over Time}
\usage{
localPCA(returns, bandwidth, m, kernel_func = epanechnikov_kernel)
}
\arguments{
\item{returns}{A numeric matrix of asset returns with dimensions \eqn{T × p}, where \eqn{T} is the 
number of time periods and \eqn{p} is the number of assets.}

\item{bandwidth}{Numeric. The bandwidth parameter used in the kernel weighting for the local PCA.}

\item{m}{Integer. The number of factors to extract.}

\item{kernel_func}{Function. The kernel function used for weighting observations. Default is 
\code{epanechnikov_kernel}.}
}
\value{
A list with the following components:
\itemize{
  \item \code{factors}: A list of length \eqn{T}, where each element is a \eqn{T × m} matrix of local factors.
  \item \code{loadings}: A list of length \eqn{T}, where each element is a \eqn{p × m} matrix of factor loadings.
  \item \code{m}: The number of factors extracted.
  \item \code{weights}: A list of length \eqn{T}, where each element is a vector of kernel weights used at that time point.
  \item \code{f_hat}: A \eqn{T × m} matrix of one-step-ahead factor estimates.
}
}
\description{
This function performs a local principal component analysis (PCA) on asset returns for each time 
period, aggregating the results over time. It calls an internal function \code{local_pca()} at each 
time index to extract local factors, loadings, and one-step-ahead factor estimates, and stores these 
results in lists. It uses previously computed factors to align the sign of the new factors.
}
\details{
The function processes the input returns over \eqn{T} time periods by iteratively calling the 
\code{local_pca()} function. For each time \eqn{t_i}:

\enumerate{
  \item Kernel weights are computed using the specified \code{kernel_func} and \code{bandwidth}.
  \item The returns are weighted by the square root of these kernel weights.
  \item An eigen decomposition is performed on the weighted returns' covariance matrix to extract the 
        top \eqn{m} eigenvectors, which are scaled by sqrt(T) to form the local factors.
  \item The signs of the new factors are aligned with those of the previous factors.
  \item The factor loadings are computed by projecting the weighted returns onto the local factors, 
        normalized by \eqn{T}.
  \item A second pass computes a one-step-ahead factor estimate for the current time period.
}
}
\section{References}{
  
Su, L., & Wang, X. (2017). On time-varying factor models: Estimation and testing. Journal of Econometrics, 198(1), 84–101.
}

