Dens2Hab <-
function(
  mrt.x,                  # Column name for the distance to the nucleus.
  mrt.y,                  # Column name for the elemental concentration.
  data,                   # Name of the dataframe to analyse (must be charged).
  Dens1,                  # Results of Density function for habitat 1.
  Dens2,                  # Results of Density function for habitat 2.
  loess=FALSE,            # Loess data instead of raw data.
  span=0.05,              # The parameter 'alpha' which controls the degree of smoothing of the loess.
  Graph=FALSE,            # To (additionally) plot the distributions of the two habitats.
  W=TRUE                  # To open new windows. Must be turned off for the fonction 'Proba1', so that graphs will be printed in a PDF file.
)
{
  # Preliminary (package & arguments) 
  if (is.function(Dens1$NFun)==FALSE){
    stop("Invalid density estimation - Dens1 must be generated by the Dens function")
  }
  if (is.function(Dens2$NFun)==FALSE){
    stop("Invalid density estimation - Dens2 must be generated by the Dens function")
  }
  if(missing(data)|missing(mrt.x)|missing(mrt.y)){
    stop("Data is missing")
  }
  
  # Data acquisition & Modelling  
  # y.data<-na.omit(data[,mrt.y])
  x.data<-data[which(data[,mrt.y]!="NA"),mrt.x]
  if (loess=="TRUE"){
    y.data<- loess(na.omit(data[,mrt.y]) ~ x.data, span=span, method="loess")$fitted
  } else {y.data<-na.omit(data[,mrt.y])}
  if(Dens1$Mode>Dens2$Mode) {
    Dens1->a;Dens1<-Dens2;Dens2<-a    
  }
  
  D1<-Dens1$NFun(y.data)
  D2<-Dens2$NFun(y.data)
    
  Equivocal<-rep(0,length=length(x.data))
    for(i in 1:length(x.data)){
      if (y.data[i]>Dens1$Min & y.data[i]<Dens1$Max & y.data[i]>Dens2$Min & y.data[i]<Dens2$Max) {
        Equivocal[i]<-"Equivocal"
      } else {
        if (xor(y.data[i]>Dens1$Min & y.data[i]<Dens1$Max,y.data[i]>Dens2$Min & y.data[i]<Dens2$Max)) {
          Equivocal[i]<-"Assigned"
        } else {Equivocal[i]<-"Unassigned"}
      }
    }
  Equivocal<-as.factor(Equivocal)
  if(any(levels(Equivocal)=="Equivocal")){
    Equ<-100/length(x.data)*length(which(Equivocal=="Equivocal"))
  } else {
    Equ<-0
  }
  if(any(levels(Equivocal)=="Unassigned")){
    Una<-100/length(x.data)*length(which(Equivocal=="Unassigned"))
  } else {
    Una<-0
  }
  if(any(levels(Equivocal)=="Assigned")){
    Ass<-100/length(x.data)*length(which(Equivocal=="Assigned"))
  } else {
    Ass<-0
  }
   
    # Habitat change
    Change<-rep(0,length=length(x.data));b<-length(x.data)-1
    Hab<-rep(0,length=b)
	  for(i in 1:b){
		if (D1[i]>D2[i]){Hab[i]<-1
		} else {if (D1[i]<D2[i]){Hab[i]<-2}
		}
		if (D1[i]>D2[i] & D1[i+1]<D2[i+1]){
		  Change[i+1]<-1
		}
		if (D1[i]<D2[i] & D1[i+1]>D2[i+1]){
		  Change[i+1]<-1
		}
	  }
	  
	rec<-rep(0,length(Change))
	init<-1
	for (i in 1:length(Change)){
	if(Change[i]==1){
	rec[i]<-init+1
	init<-init+1
	} else {rec[i]<-init}}
  
  #   dev.off()
  #   par(oma=c(1,1,1,1)mar=c(1,1,1,1))
    layout(matrix(c(1,1,1,2),4,1))
    par(oma=c(1,0,0,0))

	plot(x.data,y.data,ylab=mrt.y,xlab="Distance from primordium (micro-m)",main="Habitat assignement",col="grey");x<-par("usr")
    # polygon(c(x[1],x[2],x[2],x[1]),c(Dens1$Min,Dens1$Min,Dens1$Max,Dens1$Max),col="#FF000025")
    # polygon(c(x[1],x[2],x[2],x[1]),c(Dens2$Min,Dens2$Min,Dens2$Max,Dens2$Max),col="#0000FF25")
	# points(x.data,y.data,col="grey")
    abline(h=c(Dens1$Min,Dens1$Max,Dens2$Min,Dens2$Max),lty=c(2,2,2,2),lwd=c(1,1,1,1),col=c("red","red","blue","blue"))
    points(c(x[1],x[1]),c(Dens1$Min,Dens1$Max),col="red",pch=18,cex=2)
    points(c(x[2],x[2]),c(Dens2$Min,Dens2$Max),col="blue",pch=18,cex=2)
	Mean1<-mean(y.data[which(Hab==1)])
	Mean2<-mean(y.data[which(Hab==2)])
	Mean<-rep(0,length=b)
	for (i in 1:b){
		if(Hab[i]==1) Mean[i]<-Mean1
		if(Hab[i]==2) Mean[i]<-Mean2
	}
	MMean<-cbind(x.data[-length(x.data)],Mean)
	col<-Mean<-rep(0,length=b)
	col[which(Hab==1)]<-"red"
	col[which(Hab==2)]<-"blue"
	#points(MMean,type="l",col="black",lty=1,lwd=1)
	points(MMean,type="p",col=col)
		
  
  ## Habitat assignation
    par(mar=c(5,2,0,2))
    plot(x.data,x.data,axes=F,ann=F,ylim=c(0,2),col="white",main="Habitat use");axis(1);title(xlab="Distance from primordium")
           legend("top",c("Habitat 1","Habitat 2"),horiz=T,fill=c("red","blue"))
           for(l in 1:nlevels(as.factor(rec))) {
             if(any(Hab[which(rec[-length(rec)]==l)]==1)) {
               reds <- colorRampPalette(c("#8B0000", "#FFAEB9", "#FF0000"))
               h<-seq(from=0,to=1,length=50)
               for(m in 1:50) {
                 polygon(c(min(x.data[which(rec==l)]),max(x.data[which(rec==l)])),c(h[m],h[m]),border=reds(50)[m],col=NA)
               }
             } else {
               if(any(Hab[which(rec[-length(rec)]==l)]==2)){
                 blues <- colorRampPalette(c("#27408B", "#D1EEEE", "#4169E1"))
                 h<-seq(from=0,to=1,length=50)
                 for(m in 1:50) {
                   polygon(c(min(x.data[which(rec==l)]),max(x.data[which(rec==l)])),c(h[m],h[m]),border=blues(50)[m],col=NA)
                 }
               } else {
                 greys<-colorRampPalette(c("#3D3D3D", "#CCCCCC", "#6B6B6B"))
                 h<-seq(from=0.1,to=0.9,length=50)
                 for(m in 1:50) {
                   polygon(c(min(x.data[which(rec==l)]),max(x.data[which(rec==l)])),c(h[m],h[m]),border=greys(50)[m],col=NA)
                 }
               }
             }
           }
 
  
  
  
  if(Graph=="TRUE"){
    if(W==TRUE) dev.new()
    maxyplot<-max(D1,D2)*1.05
    minxplot<-min(y.data)
    maxxplot<-max(y.data)
    x<-seq(minxplot,maxxplot,0.1)
    plot(x,ylim=c(0, maxyplot),xlim=c(minxplot,maxxplot),type="n",ylab="Density probability",xlab="Elemental concentration")
    title(main=paste("Density probability for habitats at ",Dens1$IC*100,"%")) 
    dim<-par("usr")
    polygon(c(min(x), x, max(x)), c(0, Dens1$NFun(x), 0), col="#FF404075", border=NA)
    polygon(c(min(x), x, max(x)), c(0, Dens2$NFun(x), 0), col="#483D8B75", border=NA)
#     rug(y.data)
    abline(v=c(Dens1$Min,Dens1$Max,Dens2$Min,Dens2$Max),col=c("red","red","blue","blue"))
    xx1<-seq(Dens1$Min,Dens1$Max,0.1)
    polygon(c(Dens1$Min, xx1, Dens1$Max), c(0,Dens1$NFun(xx1), 0), col="#FF404050", border=NA)
    xx2<-seq(Dens2$Min,Dens2$Max,0.1)
    polygon(c(Dens2$Min, xx2, Dens2$Max), c(0,Dens2$NFun(xx2), 0), col="#483D8B50", border=NA)
    text(Dens1$Min,0,pos=3, round(Dens1$Min,1), col="black")
    text(Dens1$Max,0,pos=3, round(Dens1$Max,1), col="black")
    text(Dens2$Min,0,pos=3, round(Dens2$Min,1), col="black")
    text(Dens2$Max,0,pos=3, round(Dens2$Max,1), col="black")
    rug(y.data[which(y.data>Dens1$Min & y.data<Dens1$Max)],col="red")
    rug(y.data[which(y.data>Dens2$Min & y.data<Dens2$Max)],col="blue")
#     rug(y.data[which(y.data>Dens1$Max & y.data>Dens2$Max)],col="black")
#     rug(y.data[which(y.data<Dens1$Min & y.data<Dens1$Min)],col="black")
    rug(y.data[which(Equivocal=="Unassigned")],col="black")
    rug(y.data[which(Equivocal=="Equivocal")],col="grey")
  }
    #   main informations
  cat("For sample '");cat(mrt.y);cat("':");cat("\n")
  if(any(levels(Equivocal)=="Equivocal")){
    cat("   - ");cat(round(Equ,2));cat(" % of equivocal assignation given the ");cat(Dens1$IC);cat(" confidence interval");cat("\n")
  } else {
    cat("   - ");cat("No equivocal assignation given the ");cat(Dens1$IC);cat(" confidence interval");cat("\n")
  }
  if(any(levels(Equivocal)=="Unassigned")){
    cat("   - ");cat(round(Una,2));cat(" % of unassigned data given the ");cat(Dens1$IC);cat(" confidence interval");cat("\n")
  } else {
    cat("   - ");cat("No unassigned data given the ");cat(Dens1$IC);cat(" confidence interval");cat("\n")
  }
  cat("   - ");cat(round(100/length(Hab)*length(which(Hab==1)),2),"% in habitat 1");cat("\n")
  cat("   - ");cat(round(100/length(Hab)*length(which(Hab==2)),2),"% in habitat 2");cat("\n")
 
  #   return
  ans<-list(Equivocal=Equ,Unassigned=Una,Assigned=Ass)
}
