% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogNormal.R
\name{fit.LogNormal}
\alias{fit.LogNormal}
\title{Log-Normal Distribution Parameter Estimation}
\usage{
fit.LogNormal(time, status, sig = 0.05, init = NULL, eps = 1e-06,
  maxit = 10, report = F)
}
\arguments{
\item{time}{Observation times.}

\item{status}{Status indicator, coded as 1 if an event was observed, 0 if
censored.}

\item{sig}{Significance level, for CIs.}

\item{init}{List of initial parameter values, including the location "m", and
the log of the scale parameter "ls".}

\item{eps}{Tolerance for Newton-Raphson iterations.}

\item{maxit}{Maximum number of NR iterations.}

\item{report}{Report fitting progress?}
}
\value{
An object of class \code{fit} containing the following:
\describe{
 \item{Parameters}{The estimated location \eqn{\mu} and scale \eqn{\sigma}.}
 \item{Information}{The observed information matrix.}
 \item{Outcome}{The fitted mean, median, and variance.}
}
}
\description{
Estimates parameters for log-normal event times subject to non-informative
right censoring. The log-normal distribution is parameterized in terms
of the location \eqn{\mu} and scale \eqn{\sigma}:
\deqn{f(t) = \phi\left(\frac{\ln t-\mu}{\sigma}\right)\frac{1}{t\sigma}, t>0}
}
\examples{
# Simulate
D = rLogNormal(n=1e3,m=0,s=1);
# Estimate
M = fitParaSurv(time=D$time,status=D$status,dist="log-normal");
}
\seealso{
\itemize{
  \item{Fitting function for parametric survival distributions \code{\link{fitParaSurv}}}
}
}
