% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensorReg2D.R
\name{VAR_ALS}
\alias{VAR_ALS}
\title{The function computing the covariance matrices of the tensor regression parameters.}
\usage{
VAR_ALS(DATA, n_R, B1, B2, beta, family)
}
\arguments{
\item{DATA}{A list. The input data. \code{DATA$y} is the dependent variable.
\code{DATA$X} is the 3-D tensor independent variables.
\code{DATA$W} is other independent variables.}

\item{n_R}{A numerical constant. A predefined value determines the rank of
the approximate matrix}

\item{B1}{A numerical matrix. Parameter matrix B1 of the tensor regression.}

\item{B2}{A numerical matrix. Parameter matrix B2 of the tensor regression.}

\item{beta}{A numerical vector. Parameter vector of the covariates, W.}

\item{family}{Family of \kbd{generalized linear model}. Provide three options for model.(see more details in
\strong{Details})}
}
\value{
A list.
  \kbd{V_B}: A numerical matrix. Covariance matrix of the vectorized tensors' parameters.

  \kbd{V_b}: A numerical matrix. Covariance matrix of the covariates' parameters.
}
\description{
The function computing the covariance matrices of the tensor regression parameters.
}
