% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QR.R
\name{QR}
\alias{QR}
\title{QR Decomposition of a Complex Matrix without pivoting.}
\usage{
QR(A)
}
\arguments{
\item{A}{square matrix with complex entries}
}
\value{
an orthogonal matrix Q and an upper triangular matrix R so that A = QR.
}
\description{
Decomposes a complex matrix into the product of an upper triangular matrix and a lower triangular matrix.
}
\examples{
z <- complex(real = rnorm(16), imag = rnorm(16))
A <- matrix(z,nrow=4)
QR(A)
}
\references{
Stewart, G. W. (1998). Matrix algorithms: volume 1: basic decompositions. Society for Industrial and Applied Mathematics.
}
\author{
Kyle Caudle

Randy Hoover

Jackson Cates

Everett Sandbo
}
