% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar.R
\name{polar}
\alias{polar}
\title{Polar/Jordan form of matrices P and D}
\usage{
polar(P,D)
}
\arguments{
\item{P, }{the eigenvectors from an eigenvalue decomposition.}

\item{D, }{the eigenvalues from an eigenvalue decomposition.}
}
\value{
P the polar form (real-valued) matrix of eigenvectors. D the polar form (real-valued) matrix of eigenvalues.
}
\description{
Converts the complex matrices P and D into matrices of eigenvectors and eigenvalues with real entries.
}
\examples{
z <- complex(real = rnorm(16), imag = rnorm(16))
M <- matrix(z,nrow=4)
decomp <- eigen(M)
polar(decomp$vectors,decomp$values)
}
\references{
Bhatia, R. (2013). Matrix analysis (Vol. 169). Springer Science & Business Media.
}
\author{
Kyle Caudle

Randy Hoover

Jackson Cates

Everett Sandbo
}
