% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tSVD.R
\name{tSVD}
\alias{tSVD}
\title{Singular value decomposition (SVD)}
\usage{
tSVD(tnsr, tform)
}
\arguments{
\item{tnsr, }{a 3-mode tensor S3 class object}

\item{tform, }{Any discrete transform.

fft: Fast Fourier Transorm

dwt: Discrete Wavelet Transform (Haar Wavelet)

dct: Discrete Cosine transform

dst: Discrete Sine transform

dht: Discrete Hadley transform

dwht: Discrete Walsh-Hadamard transform}
}
\value{
If the SVD is performed on a \eqn{m} x \eqn{n} x \eqn{k} tensor, the components in the returned value are:

U, the left singular value tensor object (\eqn{m} x \eqn{m} x \eqn{k})

V, The right singular value tensor object (\eqn{n} x \eqn{n} x \eqn{k})

S: A diagonal tensor (\eqn{m} x \eqn{n} x \eqn{k})#' @examples
}
\description{
Performs a Singular Value Decomposition of 3 mode tensor T using any discrete transform.
The result is a left singular value tensor object U, a right singular value tensor object V, and a
diagonal tensor S so that T = USV^t
}
\examples{
T <- t_rand(modes=c(2,3,4))
print(tSVD(T,"dst"))
}
\references{
M. E. Kilmer, C. D. Martin, and L. Perrone, “A third-order generalization of the matrix svd as a product of third-order tensors,” Tufts University, Department of Computer Science, Tech. Rep. TR-2008-4, 2008

K. Braman, "Third-order tensors as linear operators on a space of matrices", Linear Algebra and its Applications, vol. 433, no. 7, pp. 1241-1253, 2010.
}
\author{
Kyle Caudle

Randy Hoover

Jackson Cates

Everett Sandbo
}
