% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Contours.R
\name{TernaryDensityContour}
\alias{TernaryDensityContour}
\title{Add contours of estimated point density to a ternary plot}
\usage{
TernaryDensityContour(coordinates, bandwidth, resolution = 25L,
  tolerance = -0.2/resolution, edgeCorrection = TRUE,
  direction = getOption("ternDirection"), ...)
}
\arguments{
\item{coordinates}{A list, matrix, data.frame or vector in which each
element (or row) specifies
the three coordinates of a point in ternary space.}

\item{bandwidth}{Vector of bandwidths for x and y directions.
Defaults to normal reference bandwidth (see MASS::bandwidth.nrd).
A scalar value will be taken to apply to both directions.}

\item{resolution}{The number of triangles whose base should lie on the longest
axis of the triangle.  Higher numbers will result in smaller subdivisions and smoother
colour gradients, but at a computational cost.}

\item{tolerance}{Numeric specifying how close to the margins the contours
should be plotted, as a fraction of the size of the triangle.
Negative values will cause contour lines to extend beyond the margins of the plot.}

\item{edgeCorrection}{Logical specifying whether to correct for edge effects
(see details).}

\item{direction}{(optional) Integer specifying the direction that the current ternary plot
should point: 1, up; 2, right; 3, down; 4, left.}

\item{\dots}{Further parameters to pass to `\link[graphics]{contour}.}
}
\description{
Uses two-dimensional kernel density estimation to plot contours of
point density.
}
\author{
Adapted from MASS::kde2d by Martin R. Smith
}
\concept{Contour plots}
