% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coordinates.R
\name{TernaryCoords}
\alias{TernaryCoords}
\alias{TernaryToXY.matrix}
\alias{TernaryToXY.numeric}
\alias{TernaryToXY}
\title{Convert ternary coordinates to Cartesian space}
\usage{
TernaryCoords(
  abc,
  b_coord = NULL,
  c_coord = NULL,
  direction = getOption("ternDirection")
)

\method{TernaryToXY}{matrix}(
  abc,
  b_coord = NULL,
  c_coord = NULL,
  direction = getOption("ternDirection")
)

\method{TernaryToXY}{numeric}(
  abc,
  b_coord = NULL,
  c_coord = NULL,
  direction = getOption("ternDirection")
)

TernaryToXY(
  abc,
  b_coord = NULL,
  c_coord = NULL,
  direction = getOption("ternDirection")
)
}
\arguments{
\item{abc}{A vector of length three giving the position on a ternary plot
that points in the direction specified by \code{direction} (1 = up, 2 = right,
3 = down, 4 = left). \code{c(100, 0, 0)} will plot in the \code{direction}-most
corner; \code{c(0, 100, 0)} will plot in the corner clockwise of \code{direction};
\code{c(0, 0, 100)} will plot in the corner anti-clockwise of \code{direction}.
Alternatively, the a coordinate can be specified as the first parameter,
in which case the b and c coordinates must be specified via \code{b_coord}
and \code{c_coord}.
Or, a matrix with three rows, representing in turn the \code{a}, \code{b} and \code{c}
coordinates of points.}

\item{b_coord}{The b coordinate, if \code{abc} is a single number.}

\item{c_coord}{The c coordinate, if \code{abc} is a single number.}

\item{direction}{(optional) Integer specifying the direction that the current ternary plot
should point: 1, up; 2, right; 3, down; 4, left.}
}
\value{
\code{TernaryCoords()} returns a vector of length two that converts
the coordinates given in \code{abc} into Cartesian (\emph{x}, \emph{y}) coordinates
corresponding to the plot created by the last call of \code{\link[=TernaryPlot]{TernaryPlot()}}.
}
\description{
Convert coordinates of a point in ternary space, in the format
(\emph{a}, \emph{b}, \emph{c}), to \emph{x} and \emph{y} coordinates of Cartesian space, which can be
sent to standard functions in the 'graphics' package.
}
\examples{
TernaryCoords(100, 0, 0)
TernaryCoords(c(0, 100, 0))

coords <- matrix(1:12, nrow = 3)
TernaryToXY(coords)

}
\seealso{
\itemize{
\item \code{\link[=TernaryPlot]{TernaryPlot()}}
}

Other coordinate translation functions: 
\code{\link{ReflectedEquivalents}()},
\code{\link{TriangleCentres}()},
\code{\link{XYToTernary}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{coordinate translation functions}
