% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoWay.r
\name{Twoway}
\alias{Twoway}
\title{Two-Way Imputation (TW)}
\usage{
Twoway(test.data, Mvalue = "NA", max.score = 1)
}
\arguments{
\item{test.data}{Test data set (a data frame or a matrix) containing missing responses. 
Missing values are coded as NA or other values (e.g., 8, 9).#'}

\item{Mvalue}{Missing response indicators in the data (e.g. "NA", "8", "9", etc.). Mvalue="NA" by default.}

\item{max.score}{The max possible response value in test data. By default max.score=1 (i.e.,binary test data).}
}
\value{
A data frame with all missing responses replaced by integrated two-way imputed values.
}
\description{
This function imputes for all missing responses using two-way imputation.
Integrated responses are obtained by rounding imputed values to the closest possible response value.
If a case showed missingness on all the variables (i.e., empty record), the missing values are 
replaced by item means first.
}
\examples{
 
        Twoway(test.data, Mvalue="8",max.score=1)
}
\references{
{
Bernaards, C. A., & Sijtsma, K. (2000).
" Influence of imputation and EM methods on factor analysis when 
item nonresponse in questionnaire data is nonignorable."
 Multivariate Behavioral Research, 35(3), 321-364.
}
}
