% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PersonMean.r
\name{PersonMean}
\alias{PersonMean}
\title{Person Mean Imputation (PM)}
\usage{
PersonMean(test.data, Mvalue = "NA", max.score = 1, round.decimal = 0)
}
\arguments{
\item{test.data}{Test data set (a data frame or a matrix) containing missing responses. 
Missing values are coded as NA or other values (e.g., 8, 9).}

\item{Mvalue}{Missing response indicators in the data (e.g. "NA", "8", "9", etc.). Mvalue="NA" by default.}

\item{max.score}{The max possible response value in test data. By default max.score=1 (i.e.,binary test data).}

\item{round.decimal}{The number of digits or decimal places for the imputed value. The default value is 0.}
}
\value{
A data frame with all missing responses replaced by person means.
}
\description{
This function imputes for all missing responses of an examinee by his/her mean (i.e., PM) 
on the available items. Integrated scores for examinees are obtained 
by rounding their means to the closest possible response value.
}
\examples{
 
        PersonMean(test.data, Mvalue="NA",max.score=1,round.decimal=0)
}
\references{
{
Sijtsma, K., & Van der Ark, L. A. (2003). 
"Investigation and treatment of missing item scores in 
test and questionnaire data."
 Multivariate Behavioral Research, 38(4), 505-528.DOI: 10.1207/s15327906mbr3804_4.
}
}
