% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{theta_FB_single}
\alias{theta_FB_single}
\title{Calculate a fully Bayesian estimate of theta for a single item}
\usage{
theta_FB_single(nx, theta_init, theta_prop, item_mcmc, item_init, resp,
  ncat, model, prior, prior_parm)
}
\arguments{
\item{nx}{The number of MCMC draws.}

\item{theta_init}{A value for initial estimate of theta.}

\item{theta_prop}{SD of the proposal distribution.}

\item{item_mcmc}{A matrix of sampled item parameters for a single item.}

\item{item_init}{A matrix of item parameter estimates (one row per item).}

\item{resp}{A numeric vector of item responses.}

\item{ncat}{A numeric vector of the number of response categories by item.}

\item{model}{A numeric vector indicating the IRT models of each item (1: 1PL, 2: 2PL, 3: 3PL, 4: PC, 5: GPC, 6: GR).}

\item{prior}{The type of prior distribution (1: normal, 2: uniform).}

\item{prior_parm}{A numeric vector of hyperparameters for the prior distribution, c(mu, sigma) or c(ll, ul).}
}
\description{
Calculate a fully Bayesian estimate of theta for a single item.
}
