% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow_class.R
\docType{class}
\name{output_Shadow-class}
\alias{output_Shadow-class}
\title{Class 'output_Shadow': adaptive assembly solution for one simulee}
\description{
\code{\linkS4class{output_Shadow}} is an S4 class to represent the adaptive assembly solution for one simulee.
}
\section{Slots}{

\describe{
\item{\code{simulee_id}}{the numeric ID of the simulee.}

\item{\code{true_theta}}{the true theta of the simulee, if was specified.}

\item{\code{true_theta_segment}}{the segment number of the true theta.}

\item{\code{final_theta_est}}{final theta estimate.}

\item{\code{final_se_est}}{the standard error of \code{final_theta_est}.}

\item{\code{administered_item_index}}{item IDs administered at each position.}

\item{\code{administered_item_resp}}{item responses from the simulee at each position.}

\item{\code{administered_item_ncat}}{the number of categories of each administered item.}

\item{\code{administered_stimulus_index}}{stimulus IDs administered at each position.}

\item{\code{shadow_test_refreshed}}{\code{TRUE} indicates the shadow test was refreshed for the position.}

\item{\code{shadow_test_feasible}}{\code{TRUE} indicates the MIP was feasible with all constraints.}

\item{\code{solve_time}}{elapsed time in running the solver at each position.}

\item{\code{initial_theta_est}}{initial theta estimate.}

\item{\code{interim_theta_est}}{interim theta estimates at each position.}

\item{\code{interim_se_est}}{the standard error of the interim estimate at each position.}

\item{\code{theta_segment_index}}{segment numbers of interim theta estimates.}

\item{\code{prior}}{prior distribution, if was specified.}

\item{\code{prior_par}}{prior parameters, if were specified.}

\item{\code{posterior}}{the posterior distribution after completing test.}

\item{\code{posterior_sample}}{posterior samples of interim theta before the estimation of final theta. \code{mean(posterior_sample) == interim_theta_est[test_length]} holds.}

\item{\code{likelihood}}{the likelihood distribution after completing test.}

\item{\code{shadow_test}}{the list containing the item IDs within the shadow test used in each position.}

\item{\code{max_cat_pool}}{the maximum number of response categories the item pool had.}

\item{\code{ni_pool}}{the total number of items the item pool had.}

\item{\code{ns_pool}}{the total number of stimuli the item pool had.}

\item{\code{test_length_constraints}}{the test length constraint used in assembly.}

\item{\code{set_based}}{whether the item pool was set-based.}

\item{\code{item_index_by_stimulus}}{the list of items by each stimulus the item pool had.}
}}

