% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate.R
\name{univariate}
\alias{univariate}
\title{univariate}
\usage{
univariate(x, Pop = 1, lower_tail = FALSE, padjust = "none",
  pairwise = FALSE, pairwise_tail = "two")
}
\arguments{
\item{x}{Data frame containing summary statistics of both sexes for two or
more populations.}

\item{Pop}{Number of the column containing populations' names, Default:
\code{1}}

\item{lower_tail}{Logical; if \code{TRUE} probabilities are \code{P[X <= x]},
otherwise, \code{P[X > x]}., Default: \code{FALSE}}

\item{padjust}{Method of p value adjustment for multiple comparisons
following \code{p.adjust.methods}, Default: \code{'none'}}

\item{pairwise}{Logical; if \code{TRUE} runs multiple pairwise comparisons on
different populations using \code{Tg} test, Default: \code{FALSE}}

\item{pairwise_tail}{Number of t test tails, Default: \code{'two'}}
}
\value{
ANOVA table
}
\description{
Calculation of the significance of the differences in
  interpopulation degree of sexual dimorphism using a modified one-way ANOVA
  which utilizes summary statistics as input.
}
\details{
Data is entered in a wide format with each row representing a given
  population.\code{Pop}  (first column by default) contains population names,
  \code{.mu} and \code{.sdev} contain means and standard deviations with
  \code{M} and \code{F} donating males and females respectively. While
  \code{m}&\code{f} are the male and female sample sizes. When more than two
  populations are tested,\code{p.adjust.methods:
  c('holm','hochberg','hommel', 'bonferroni','BH','BY','fdr','none')} can be
  used for p value adjustment.
}
\examples{
 # Comaprison of femur head diameter in four populations
m <- c(150.00, 82.00, 36.00, 34.00)
f <- c(150.00, 58.00, 34.00, 24.00)
M.mu <- c(49.39, 48.33, 46.99, 45.20)
F.mu <- c(42.91, 42.89, 42.44, 40.90)
M.sdev <- c(3.01, 2.53, 2.47, 2.00)
F.sdev <- c(2.90, 2.84, 2.26, 2.90)
df <- cbind.data.frame(
  Pop = c('Turkish', 'Bulgarian', 'Greek', 'Portuguese '),
  m,
  f,
  M.mu,
  F.mu,
  M.sdev,
  F.sdev,
  stringsAsFactors = TRUE
)
TestDimorph::univariate(x = df, pairwise = TRUE, padjust = 'bonferroni')

}
\references{
\insertRef{konigsberg1991historical}{TestDimorph}

  \insertRef{timonov2014study}{TestDimorph}

  \insertRef{curate2017sex}{TestDimorph}

  \insertRef{kranioti2009sex}{TestDimorph}

  \insertRef{gulhan2015new}{TestDimorph}
}
