% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hedges_g.R
\name{Hedges_g}
\alias{Hedges_g}
\title{Hedges' g}
\usage{
Hedges_g(
  x,
  Trait = 1,
  CI = 0.95,
  B = NULL,
  verbose = FALSE,
  rand = TRUE,
  digits = 4
)
}
\arguments{
\item{x}{A data frame containing summary statistics.}

\item{Trait}{Number of the column containing names of measured parameters,
Default: 1}

\item{CI}{confidence interval coverage takes value from 0 to 1, Default: 0.95.}

\item{B}{number of bootstrap samples for generating confidence intervals. Higher
number means greater accuracy but slower execution. If NULL bootstrap confidence
intervals are not produced, Default:NULL}

\item{verbose}{logical; if TRUE  number of bootstraps is displayed,
Default: FALSE}

\item{rand}{logical; if TRUE, uses random seed.  If FALSE, then set.seed(42)
for repeatability, Default: TRUE}

\item{digits}{Number of significant digits, Default: 4}
}
\value{
a table of Hedge's g values with confidence interval for different traits.
}
\description{
quantifies the size of difference between sexes in measured traits.
}
\details{
Calculates Hedges' (1981) g and its confidence intervals using
the pooled standard deviation and correcting for bias.  See Goulet-Pelletier
and Cousineau (2018) for details of the calculations and \link{D_index} for
description of the bootstrap.
}
\examples{
library(TestDimorph)
data("Cremains_measurements")
# Confidence intervals with non-central t distribution
Hedges_g(Cremains_measurements[1, ])
\dontrun{
# confidence interval with bootstrapping
Hedges_g(Cremains_measurements[1, ], rand = FALSE, B = 1000)
}
}
\references{
Hedges, L. V. (1981). Distribution theory for Glass's estimator
of effect size and related estimators. Journal of Educational Statistics,
6(2), 107-128.


Goulet-Pelletier, J.-C., & Cousineau, D. (2018). A review of effect sizes and
their confidence intervals, part I: The Cohen's d family. The Quantitative
Methods for Psychology, 14(4), 242-265.
}
