% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patients.R
\name{readPatients.csv}
\alias{readPatients.csv}
\title{Converts a sample of patients in CSV format into a Unit Testing Definition JSON file.}
\usage{
readPatients.csv(
  filePath = NULL,
  testName = "test",
  outputPath = NULL,
  cdmVersion = "5.3",
  reduceLargeIds = FALSE
)
}
\arguments{
\item{filePath}{Path to the test patient data in CSV format. Multiple CSV files representing tables tables from the OMOP-CDM must be provided, e.g. person.csv, drug_exposure.csv, condition_ocurrence.csv, etc.}

\item{testName}{Name for the test population file in character.}

\item{outputPath}{Path of the output file, if NULL, a folder will be created in the project folder inst/testCases.}

\item{cdmVersion}{cdm version, default "5.3".}

\item{reduceLargeIds}{Reduces the length of very long ids generally in int64 format, such as those found in the MIMIC-IV database.}
}
\value{
A JSON file with sample patients inside the project directory.
}
\description{
Converts a sample of patients in CSV format into a Unit Testing Definition JSON file.
}
\examples{
filePath <- system.file("extdata", "mimic_sample", package = "TestGenerator")
readPatients.csv(filePath = filePath, outputPath = tempdir())

}
