% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TideCurve.R
\name{TideCurve}
\alias{TideCurve}
\title{Computes tide curves}
\usage{
TideCurve(dataInput, otz = 1, km = -1, mindt = 30, asdate, astime, aedate,
  aetime, ssdate, sstime, sedate, setime)
}
\arguments{
\item{dataInput}{A data frame with the columns observation_date, observation_time and height. See attached data for correct formats.}

\item{otz}{The time zone of the observations}

\item{km}{The number of nodes between two consecutive mean moon transits. Shall be less or equal to: round(1440 [min] / time step [min])
Example: Time step 5 min: Use km = 288 or even smaller. Leave on default (km = -1) and supply mindt, when unsure.}

\item{mindt}{Observation time step in [min]. Default is 30.}

\item{asdate}{A string indication the date you want the analysis to start with. Format: "yyyy/mm/dd".}

\item{astime}{A string indicating the time you want the analysis to start with. Format: "hh:mm:ss"}

\item{aedate}{A string indication the date you want the analysis to end with. Format: "yyyy/mm/dd".}

\item{aetime}{A string indicating the time you want the analysis to end with. Format: "hh:mm:ss"}

\item{ssdate}{Synthesis start date. This indicates the date you want your tide curve to start with. Format: See above}

\item{sstime}{Synthesis start time. The starting time for your tide table. Format: See above}

\item{sedate}{Synthesis end date. Format: See above}

\item{setime}{Synthesis end time. Format: See above}
}
\value{
Returns a list with elements of the analysis, fitting and the tidal curve for given data
\item{synthesis.lunar}{The lunar synthesis data as a data.table object in UTC}
\item{data.matrix}{The data needed for analysis}
\item{tide.curve}{The solar tide curve as a data.table object (provided time zone)}
\item{lm.coeff}{Coefficients for the km fitted linear models used in the synthesis}
\item{diff.analyse}{Time in days spanning the analysis}
}
\description{
Takes a data frame as input with three columns (see example dataset) and returns a tide curve.
Internally the analysis is carried out in lunar days.
One mean lunar day lasts 1.0350501 mean solar days.
Therefore the analysis time period
should start one lunar day after the first observation and end one lunar day before the last observation.
}
\examples{
TideCurve(dataInput = tideObservation, asdate = "2015/12/06",
             astime = "00:00:00",      aedate = "2015/12/31",
             aetime = "23:30:00",      ssdate = "2015/12/17",
             sstime = "00:00:00",      sedate = "2015/12/31",
             setime = "23:30:00")

}
\references{
Godin, Gabriel (1972) The Analysis of Tides. Toronto, 264pp

\url{https://www.ocean-sci.net/15/1363/2019/}

\url{http://tidesandcurrents.noaa.gov/publications/glossary2.pdf}

\url{https://www.bsh.de/DE/PUBLIKATIONEN/_Anlagen/Downloads/Meer_und_Umwelt/Berichte-des-BSH/Berichte-des-BSH-50_de.pdf}
}
