% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Summary.R
\name{summary.Tides}
\alias{summary.Tides}
\title{Summary of tidal characteristics}
\usage{
\method{summary}{Tides}(object, ...)
}
\arguments{
\item{object}{Tides object (e.g. the result of \code{\link{TidalCharacteristics}})}

\item{...}{Not used (Added for S3 method compatibility)}
}
\value{
A list containing: 
\itemize{
\item{IFsum:}{ Inundation frequency: see IF(). The proportion of high water tides higher than h0. A warning will be displayed when the inundation frequency is 100\%.}
\item{nIndsum:}{ Inundations during time span, when the waterlevel > h0.}
\item{IHsum:}{ Average inundation height. A warning will be displayed when the inundation frequency is 100\%.}
\item{IHcsum:}{ Average inundation height (per cycle).}

\item{Tunitssum:}{ time units}
\item{ITsum:}{ Average inundation time, in Tunitssum A warning will be displayed when h0 is never inundated}
\item{ITCsum:}{ Average inundation time (per cycle), in Tunitssum}
\item{ITMsum:}{ Maximal inundation time, in Tunitssum}
\item{DTsum:}{ Average dry time, in Tunitssum}
\item{DTCsum:}{ Average dry time (per cycle), in Tunitssum}
\item{DTMsum:}{ Maximal dry time, in Tunitssum}

\item{MHWsum:}{ Average high water. Note that the calculated HW and LW are always >= h0!}
\item{MLWsum:}{ Average low water. Note that the calculated HW and LW are always >= h0!}
\item{TRsum:}{ Average tidal range. Note that the calculated HW and LW are always >= h0!}

\item{nTCsum:}{ number of (tidal) cycles}
\item{nTCFsum:}{ number of full tidal cycles (used to measure averages per cycle)}

\item{nGsum:}{ number of gaps}
\item{GTsum:}{ total gaps time in mins}
\item{nTSsum:}{ number of continuous timeseries}
\item{TTNoGapsum:}{ total continuous timeseries time (without gaps, also tidal phases before and after gap are not included)}

\item{ITTsum:}{ total inundation time (without gaps, and also tidal phases before and after gap are not included)}
\item{DTTsum:}{ total dry time (without gaps, and also tidal phases before and after gap are not included)}
\item{IPsum:}{ proportion of total time inundated (without gaps, and also tidal phases before and after gap are not included)}
\item{DPsum:}{ DTTsum/TSsum # proportion of total time dry (without gaps, and also tidal phases before and after gap are not included)}
}
}
\description{
Outputs list of summary statistics of a Tides oabject
}
\author{
{Lennert Schepers <Lennert.Schepers@uantwerp.be>, Tom Cox <tom.cox@uantwerp.be>}
}
