% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random-tidy-cauchy.R
\name{tidy_cauchy}
\alias{tidy_cauchy}
\title{Tidy Randomly Generated Cauchy Tibble}
\usage{
tidy_cauchy(.n = 50, .location = 0, .scale = 1, .num_sims = 1)
}
\arguments{
\item{.n}{The number of randomly generated points you want.}

\item{.location}{The location parameter.}

\item{.scale}{The scale parameter, must be greater than or equal to 0.}

\item{.num_sims}{The number of randomly generated simulations you want.}
}
\value{
A tibble of randomly generated data.
}
\description{
This function will generate \code{n} random points from a cauchy
distribution with a user provided, \code{.location}, \code{.scale}, and number of
random simulations to be produced. The function returns a tibble with the
simulation number column the x column which corresponds to the n randomly
generated points, the \code{d_}, \code{p_} and \code{q_} data points as well.

The data is returned un-grouped.

The columns that are output are:
\itemize{
\item \code{sim_number} The current simulation number.
\item \code{x} The current value of \code{n} for the current simulation.
\item \code{y} The randomly generated data point.
\item \code{dx} The \code{x} value from the \code{\link[stats:density]{stats::density()}} function.
\item \code{dy} The \code{y} value from the \code{\link[stats:density]{stats::density()}} function.
\item \code{p} The values from the resulting p_ function of the distribution family.
\item \code{q} The values from the resulting q_ function of the distribution family.
}
}
\details{
This function uses the underlying \code{stats::rcauchy()}, and its underlying
\code{p}, \code{d}, and \code{q} functions. For more information please see \code{\link[stats:Cauchy]{stats::rcauchy()}}
}
\examples{
tidy_cauchy()

}
\seealso{
\url{https://www.itl.nist.gov/div898/handbook/eda/section3/eda3663.htm}

Other Data Generator: 
\code{\link{tidy_beta}()},
\code{\link{tidy_chisquare}()},
\code{\link{tidy_exponential}()},
\code{\link{tidy_f}()},
\code{\link{tidy_gamma}()},
\code{\link{tidy_hypergeometric}()},
\code{\link{tidy_logistic}()},
\code{\link{tidy_lognormal}()},
\code{\link{tidy_normal}()},
\code{\link{tidy_poisson}()},
\code{\link{tidy_uniform}()},
\code{\link{tidy_weibull}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Data Generator}
