% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot-randomwalk.R
\name{tidy_random_walk_autoplot}
\alias{tidy_random_walk_autoplot}
\title{Automatic Plot of Random Walk Data}
\usage{
tidy_random_walk_autoplot(
  .data,
  .line_size = 1,
  .geom_rug = FALSE,
  .geom_smooth = FALSE,
  .interactive = FALSE
)
}
\arguments{
\item{.data}{The data passed in from a tidy_\code{distribution} function like
\code{tidy_normal()}}

\item{.line_size}{The size param ggplot}

\item{.geom_rug}{A Boolean value of TRUE/FALSE, FALSE is the default. TRUE
will return the use of \code{ggplot2::geom_rug()}}

\item{.geom_smooth}{A Boolean value of TRUE/FALSE, FALSE is the default. TRUE
will return the use of \code{ggplot2::geom_smooth()} The \code{aes} parameter of group is
set to FALSE. This ensures a single smoothing band returned with SE also set to
FALSE. Color is set to 'black' and \code{linetype} is 'dashed'.}

\item{.interactive}{A Boolean value of TRUE/FALSE, FALSE is the default. TRUE
will return an interactive \code{plotly} plot.}
}
\value{
A ggplot or a plotly plot.
}
\description{
This is an auto-plotting function that will take in a \code{tidy_}
distribution function and a few arguments with regard to the output of the
visualization.

If the number of simulations exceeds 9 then the legend will not print. The plot
subtitle is put together by the attributes of the table passed to the function.
}
\details{
This function will produce a simple random walk plot from a \code{tidy_}
distribution function.
}
\examples{
tidy_normal(.sd = .1, .num_sims = 5) \%>\%
  tidy_random_walk(.value_type = "cum_sum") \%>\%
  tidy_random_walk_autoplot()

tidy_normal(.sd = .1, .num_sims = 20) \%>\%
  tidy_random_walk(.value_type = "cum_sum", .sample = TRUE, .replace = TRUE) \%>\%
  tidy_random_walk_autoplot()

}
\seealso{
Other Autoplot: 
\code{\link{tidy_autoplot}()},
\code{\link{tidy_combined_autoplot}()},
\code{\link{tidy_multi_dist_autoplot}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Autoplot}
