% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est-param-zt-geometric.R
\name{util_zero_truncated_geometric_param_estimate}
\alias{util_zero_truncated_geometric_param_estimate}
\title{Estimate Zero-Truncated Geometric Parameters}
\usage{
util_zero_truncated_geometric_param_estimate(.x, .auto_gen_empirical = TRUE)
}
\arguments{
\item{.x}{The vector of data to be passed to the function. Must contain
non-negative integers and should have no zeros.}

\item{.auto_gen_empirical}{Boolean value (default \code{TRUE}) that, when set to
\code{TRUE}, will generate \code{tidy_empirical()} output for \code{.x} and combine it with
the estimated distribution data.}
}
\value{
A tibble/list
}
\description{
This function will estimate the \code{prob} parameter for a
Zero-Truncated Geometric distribution from a given vector \code{.x}. The function
returns a list with a parameter table, and if \code{.auto_gen_empirical} is set
to \code{TRUE}, the empirical data is combined with the estimated distribution
data.
}
\details{
This function will attempt to estimate the \code{prob} parameter of the
Zero-Truncated Geometric distribution using given vector \code{.x} as input data.
If the parameter \code{.auto_gen_empirical} is set to \code{TRUE}, the empirical data
in \code{.x} will be run through the \code{tidy_empirical()} function and combined with
the estimated zero-truncated geometric data.
}
\examples{
library(actuar)
library(dplyr)
library(ggplot2)
library(actuar)

set.seed(123)
ztg <- rztgeom(100, prob = 0.2)
output <- util_zero_truncated_geometric_param_estimate(ztg)

output$parameter_tbl

output$combined_data_tbl |>
  tidy_combined_autoplot()

}
\seealso{
Other Parameter Estimation: 
\code{\link{util_bernoulli_param_estimate}()},
\code{\link{util_beta_param_estimate}()},
\code{\link{util_binomial_param_estimate}()},
\code{\link{util_burr_param_estimate}()},
\code{\link{util_cauchy_param_estimate}()},
\code{\link{util_chisquare_param_estimate}()},
\code{\link{util_exponential_param_estimate}()},
\code{\link{util_f_param_estimate}()},
\code{\link{util_gamma_param_estimate}()},
\code{\link{util_generalized_beta_param_estimate}()},
\code{\link{util_generalized_pareto_param_estimate}()},
\code{\link{util_geometric_param_estimate}()},
\code{\link{util_hypergeometric_param_estimate}()},
\code{\link{util_inverse_burr_param_estimate}()},
\code{\link{util_inverse_pareto_param_estimate}()},
\code{\link{util_inverse_weibull_param_estimate}()},
\code{\link{util_logistic_param_estimate}()},
\code{\link{util_lognormal_param_estimate}()},
\code{\link{util_negative_binomial_param_estimate}()},
\code{\link{util_normal_param_estimate}()},
\code{\link{util_paralogistic_param_estimate}()},
\code{\link{util_pareto1_param_estimate}()},
\code{\link{util_pareto_param_estimate}()},
\code{\link{util_poisson_param_estimate}()},
\code{\link{util_t_param_estimate}()},
\code{\link{util_triangular_param_estimate}()},
\code{\link{util_uniform_param_estimate}()},
\code{\link{util_weibull_param_estimate}()},
\code{\link{util_zero_truncated_binomial_param_estimate}()},
\code{\link{util_zero_truncated_negative_binomial_param_estimate}()},
\code{\link{util_zero_truncated_poisson_param_estimate}()}

Other Zero-Truncated Geometric: 
\code{\link{util_zero_truncated_geometric_stats_tbl}()}
}
\concept{Parameter Estimation}
\concept{Zero-Truncated Geometric}
