% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-spatial.R
\name{coast_distance}
\alias{coast_distance}
\title{Vectorized distance to coast}
\usage{
coast_distance(
  lon,
  lat,
  coastline = NULL,
  return_indices = FALSE,
  distance_type = "haversine",
  unit = "nm",
  window = 1,
  parallel = FALSE,
  cores = 4
)
}
\arguments{
\item{lon}{Numeric vector with the longitudes of the points of interest.}

\item{lat}{Numeric vector with the latitudes of the points of interest.}

\item{coastline}{Data frame with coastline coordinates. Must have columns named \code{Long} and \code{Lat}.
If \code{NULL}, uses internal dataset \code{peru_coastline}.}

\item{return_indices}{Logical. If \code{TRUE}, also returns the indices of the nearest coastline points.}

\item{distance_type}{Type of geographic distance to use: "haversine", "euclidean", "grid".}

\item{unit}{Unit of measurement for distance: "nm" (nautical miles), "km", etc.}

\item{window}{Search window in degrees around the point to limit calculations and improve efficiency.}

\item{parallel}{Logical. If \code{TRUE}, performs the calculation in parallel using multiple cores.}

\item{cores}{Number of cores to use for parallel processing.}
}
\value{
If \code{return_indices = FALSE}, returns a numeric vector with distances to the coast for each point.
If \code{return_indices = TRUE}, returns a list with distance and index components.
}
\description{
Estimates the distance between a set of points (lon, lat) and a coastline defined by coordinates.
Can be executed sequentially or in parallel, and also return the indices of the nearest coastal points.
}
\examples{
\dontrun{
data_hauls <- process_hauls(data_hauls = calas_bitacora)
distances <- coast_distance(
  lon = data_hauls$lon_final,
  lat = data_hauls$lat_final,
  distance_type = "haversine",
  unit = "nm",
  parallel = TRUE,
  cores = 2
)
}

}
