% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToxicoSet.R
\name{checkTSetStructure}
\alias{checkTSetStructure}
\title{A function to verify the structure of a ToxicoSet}
\usage{
checkTSetStructure(tSet, plotDist = FALSE, result.dir = tempdir())
}
\arguments{
\item{tSet}{A \code{ToxicoSet} object}

\item{plotDist}{Should the function also plot the distribution of molecular data?}

\item{result.dir}{The path to the directory for saving the plots as a string, defaults to `tempdir()`}
}
\value{
Prints out messages whenever describing the errors found in the structure of the pset object passed in.
}
\description{
This function checks the structure of a ToxicoSet, ensuring that the
correct annotations are in place and all the required slots are filled so
that matching of cells and drugs can be properly done across different types
of data and with other studies.
}
\examples{

checkTSetStructure(TGGATESsmall)

}
