% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\name{tplyr_table}
\alias{tplyr_table}
\title{Create a Tplyr table object}
\usage{
tplyr_table(target, treat_var, where = TRUE, cols = vars())
}
\arguments{
\item{target}{Dataset upon which summaries will be performed}

\item{treat_var}{Variable containing treatment group assignments. Supply unquoted.}

\item{where}{A general subset to be applied to all layers. Supply as programming logic (i.e. x < 5 & y == 10)}

\item{cols}{A grouping variable to summarize data by column (in addition to treat_var). Provide multiple
column variables by using \code{\link[dplyr]{vars}}}
}
\value{
A \code{tplyr_table} object
}
\description{
The \code{tplyr_table} object is the main container upon which a Tplyr table is constructed. Tplyr tables are made up of
one or more layers. Each layer contains an instruction for a summary to be performed. The \code{tplyr_table} object contains
those layers, and the general data, metadata, and logic necessary.
}
\details{
When a \code{tplyr_table} is created, it will contain the following bindings:
\itemize{
\item{target - The dataset upon which summaries will be performed}
\item{pop_data - The data containing population information. This defaults to the target dataset}
\item{cols - A categorical variable to present summaries grouped by column (in addition to treat_var)}
\item{table_where - The \code{where} parameter provided, used to subset the target data}
\item{treat_var - Variable used to distinguish treatment groups.}
\item{header_n - Default header N values based on \code{treat_var}}
\item{pop_treat_var - The treatment variable for \code{pop_data} (if different)}
\item{layers - The container for individual layers of a \code{tplyr_table}}
\item{treat_grps - Additional treatment groups to be added to the summary (i.e. Total)}
}

\code{tplyr_table} allows you a basic interface to instantiate the object. Modifier functions are available to change
individual parameters catered to your analysis. For example, to add a total group, you can use the
\code{\link{add_total_group}}.

In future releases, we will provide vigenttes to fully demonstrate these capabilities.
}
\examples{

tab <- tplyr_table(iris, Species, where = Sepal.Length < 5.8)

}
