% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TLLiNGAM.R
\name{TLLiNGAM}
\alias{TLLiNGAM}
\title{Learning linear non-Gaussian DAG via topological layers.}
\usage{
TLLiNGAM (X, hardth=0.3, criti.val=0.01, precision.refit = TRUE,
                 precision.method="glasso", B.refit=TRUE)
}
\arguments{
\item{X}{The n * p sample matrix, where n is the sample size and p is data dimension.}

\item{hardth}{The hard threshold of regression.}

\item{criti.val}{The critical value of independence test based on distance covariance.}

\item{precision.refit}{Whether to perform regression for re-fitting the coefficients in the precision matrix to improve estimation accuracy, after determining the non-zero elements of the precision matrix. The default is True.}

\item{precision.method}{Methods for Estimating Precision Matrix, which can be selected from "glasso" and "CLIME".}

\item{B.refit}{Whether to perform regression for re-fitting the coefficients in structural equation models to improve estimation accuracy, after determining the parent sets of all nodes. The default is True.}
}
\value{
A result list including:
\describe{
\item{A}{The information of layer.}
\item{B}{The coefficients in structural equation models.}
}
}
\description{
Learning linear non-Gaussian DAG via topological layers.
}
\examples{
# Please see vignettes.


}
\references{
Zhao, R., He X., and Wang J. (2022). Learning linear non-Gaussian directed acyclic graph with diverging number of nodes. Journal of Machine Learning Research.
}
\author{
Ruixuan Zhao \href{mailto:ruixuanzhao2-c@my.cityu.edu.hk}{ruixuanzhao2-c@my.cityu.edu.hk}, Xin He, and Junhui Wang
}
