% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getParam.R
\name{getParam}
\alias{getParam}
\title{Get Parameter Posterior Statistics}
\usage{
getParam(fittedModel, parameter = "mean", stat = "mean", file = NULL)
}
\arguments{
\item{fittedModel}{a fitted latent-trait MPT model (see \code{\link{traitMPT}}) or beta MPT model (see \code{\link{betaMPT}})}

\item{parameter}{which parameter(s) should be returned? (see below for details)}

\item{stat}{whether to get the posterior \code{"mean"}, \code{"median"}, \code{"sd"}, or \code{"summary"} (includes mean, SD, and 95\% credibility interval)}

\item{file}{filename to export results in .csv format (e.g., \code{file="est_param.csv"})}
}
\description{
Returns posterior statistics (e.g., mean, median) for the parameters of a hierarchical MPT model.
}
\details{
This function is a convenient way to get the information stored in \code{fittedModel$mcmc.summ}.

The latent-trait MPT includes the following parameters:
\itemize{
\item \code{"mean"} (group means on probability scale)
\item \code{"mu"} (group means on probit scale)
\item \code{"sigma"} (SD on probit scale)
\item \code{"rho"} (correlations on probit scale)
\item \code{"theta"} (individual MPT parameters)
}

The beta MPT includes the following parameters:
\itemize{
\item \code{"mean"} (group means on probability scale)
\item \code{"sd"} (SD on probability scale)
\item \code{"alph"},\code{"bet"} (group parameters of beta distribution)
\item \code{"theta"} (individual MPT parameters)
}
}
\examples{
\dontrun{
# mean estimates per person:
getParam(fittedModel, parameter = "theta")

# save summary of individual estimates:
getParam(fittedModel, parameter = "theta",
         stat = "summary", file= "ind_summ.csv")}
}
\seealso{
\code{\link{getGroupMeans}} mean group estimates
}
\author{
Daniel Heck
}
