% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WAIC.R
\name{WAIC}
\alias{WAIC}
\title{Widely Applicable Information Criterion}
\usage{
WAIC(fittedModel, n.adapt = 1000, n.chains = 3, n.iter = 10000,
  n.thin = 1)
}
\arguments{
\item{fittedModel}{fitted latent-trait or beta MPT model (\code{\link{traitMPT}}, \code{\link{betaMPT}})}

\item{n.adapt}{number of adaptation samples.}

\item{n.chains}{number of chains (no parallel computation).}

\item{n.iter}{number of iterations after burnin.}

\item{n.thin}{Thinning rate.}
}
\value{
a vector with the WAIC penalty \code{"p_waic"}, deviance \code{"deviance"}, and the WAIC \code{"waic"}.
}
\description{
Experimental implementation of the WAIC.
}
\details{
Please note that the implementation uses an experimental feature of the JAGS version
4.3.0. It might be a good idea to fit each model and compute WAIC twice to
assess the stability of the WAIC values. See the following discussion for
details:

\url{https://sourceforge.net/p/mcmc-jags/discussion/610036/thread/8211df61/}
}
\examples{
\dontrun{
fit <- traitMPT(...)
WAIC(fit)
}

}
\references{
Vehtari, A., Gelman, A., & Gabry, J. (2017). Practical Bayesian model
evaluation using leave-one-out cross-validation and WAIC. Statistics and
Computing, 27(5), 1413–1432. doi:10.1007/s11222-016-9696-4
}
