% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNI.R
\name{NNI}
\alias{NNI}
\alias{cNNI}
\alias{NNISwap}
\alias{RootedNNI}
\alias{RootedNNISwap}
\title{Nearest neighbour interchange (NNI)}
\usage{
NNI(tree, edgeToBreak = NULL)

cNNI(tree, edgeToBreak = NULL, whichSwitch = NULL)

NNISwap(parent, child, nTips = (length(parent)/2L) + 1L, edgeToBreak = NULL)

RootedNNI(tree, edgeToBreak = NULL)

RootedNNISwap(
  parent,
  child,
  nTips = (length(parent)/2L) + 1L,
  edgeToBreak = NULL
)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}.}

\item{edgeToBreak}{In (\code{Rooted})\code{NNI()}, an optional integer specifying the
index of an edge to bisect/prune, generated randomly if not specified.
If \code{-1}, a complete list of all trees one step from the input tree
will be returned.
In \code{cNNI()}, an integer from zero to \code{nEdge(tree) - nTip(tree) - 2},
specifying which internal edge to break.}

\item{whichSwitch}{Integer from zero to one, specifying which way to re-build
the broken internal edge.}

\item{parent}{Integer vector corresponding to the first column of the edge
matrix of a tree of class \code{\link{phylo}}, i.e. \code{tree$edge[, 1]}.}

\item{child}{Integer vector corresponding to the second column of the edge
matrix of a tree of class \code{\link{phylo}}, i.e. \code{tree$edge[, 2]}.}

\item{nTips}{(optional) Number of tips.}
}
\value{
Returns a tree with class \code{phylo} (if \code{returnAll = FALSE}) or
a set of trees, with class \code{multiPhylo} (if \code{returnAll = TRUE}).

\code{cNNI()} returns a tree of class \code{phylo}, rooted on the same leaf,
on which the specified rearrangement has been conducted.

\code{NNISwap()} returns a list containing two elements, corresponding in
turn to the  rearranged parent and child parameters.

a list containing two elements, corresponding in turn to the rearranged parent and child parameters
}
\description{
\code{NNI()}performs a single iteration of the nearest-neighbour interchange
algorithm; \code{RootedNNI()} retains the position of the root.
These functions are based on equivalents in the '\pkg{phangorn}' package.
\code{cNNI()} is an equivalent function coded in C, that runs much faster.
}
\details{
Branch lengths are not supported.

All nodes in a tree must be bifurcating; \code{\link[ape:collapse.singles]{ape::collapse.singles()}} and
\code{\link[ape:multi2di]{ape::multi2di()}} may help.
}
\section{Functions}{
\itemize{
\item \code{NNISwap}: faster version that takes and returns parent and child parameters

\item \code{RootedNNI}: Perform \acronym{NNI} rearrangement, retaining position of root

\item \code{RootedNNISwap}: faster version that takes and returns parent and child parameters
}}

\examples{
tree <- TreeTools::BalancedTree(8)
# A random rearrangement
NNI(tree)
cNNI(tree)

# All trees one NNI rearrangement away
NNI(tree, edgeToBreak = -1)

# Manual random sampling
cNNI(tree, sample.int(14 - 8 - 1, 1), sample.int(2, 1))

# A specified rearrangement
cNNI(tree, 0, 0)

# If a tree may not be binary, collapse nodes with
tree <- TreeTools::MakeTreeBinary(tree)

# If a tree may be improperly rooted, use
tree <- TreeTools::RootTree(tree, 1)

# If a tree may exhibit unusual node ordering, this can be addressed with
tree <- TreeTools::Preorder(tree)
}
\references{
The algorithm is summarized in
\insertRef{Felsenstein2004}{TreeSearch}
}
\seealso{
Other tree rearrangement functions: 
\code{\link{SPR}()},
\code{\link{TBR}()}
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree rearrangement functions}
