% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomTreeScore.R
\name{RandomTreeScore}
\alias{RandomTreeScore}
\title{Parsimony score of random postorder tree}
\usage{
RandomTreeScore(morphyObj)
}
\arguments{
\item{morphyObj}{Object of class \code{morphy}, perhaps created with
\code{\link[=PhyDat2Morphy]{PhyDat2Morphy()}}.}
}
\value{
\code{RandomTreeScore()} returns the parsimony score of a random tree
for the given Morphy object.
}
\description{
Parsimony score of random postorder tree
}
\examples{
tokens <- matrix(c(
  0, '-', '-', 1, 1, 2,
  0, 1, 0, 1, 2, 2,
  0, '-', '-', 0, 0, 0), byrow = TRUE, nrow = 3L,
  dimnames = list(letters[1:3], NULL))
pd <- TreeTools::MatrixToPhyDat(tokens)
morphyObj <- PhyDat2Morphy(pd)

RandomTreeScore(morphyObj)

morphyObj <- UnloadMorphy(morphyObj)
}
