% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolEscapa.R
\name{LengthAdded}
\alias{LengthAdded}
\alias{PolEscapa}
\title{Contribution of character to leaf instability}
\usage{
LengthAdded(trees, char, concavity = Inf)

PolEscapa(trees, char, concavity = Inf)
}
\arguments{
\item{trees}{List of trees of class \code{phylo}, or \code{multiPhylo} object.}

\item{char}{\code{phyDat} object containing a single character.}

\item{concavity}{Determines the degree to which extra steps beyond the first
are penalized.  Specify a numeric value to use implied weighting
\insertCite{Goloboff1993}{TreeSearch}; \code{concavity} specifies \emph{k} in
\emph{k} / \emph{e} + \emph{k}. A value of 10 is recommended;
TNT sets a default of 3, but this is too low in some circumstances
\insertCite{Goloboff2018,Smith2019}{TreeSearch}.
Better still explore the sensitivity of results under a range of
concavity values, e.g. \code{k = 2 ^ (1:7)}.
Specify \code{Inf} to weight each additional step equally,
(which underperforms step weighting approaches
\insertCite{Goloboff2008,Goloboff2018,Goloboff2019,Smith2019}{TreeSearch}).
Specify \code{"profile"} to employ an approximation of profile parsimony
\insertCite{Faith2001}{TreeSearch}.}
}
\value{
\code{LengthAdded()} returns a named numeric vector listing the mean
absolute change to tree length resulting if the character were coded
ambiguous for each leaf in turn, under the specified concavity constant.
}
\description{
Would tree lengths change if a character was coded as ambiguous for each
leaf \insertCite{Pol2009}{TreeSearch}?
}
\details{
High values for a leaf indicate that its coding contributes to instability
("wildcard" or "roguish" behaviour; see
\href{https://ms609.github.io/Rogue/}{\pkg{Rogue}}for further details).
The coding is in tension with other data, which may indicate that the
assumptions of homology that underlie the character's construction and
scoring require careful scrutiny – or that the taxon in question has
been subject to convergent evolution.

When inapplicable tokens are present in a character, the applicability of
each coding is maintained: i.e. a leaf coded with an applicable token is
never allowed to take an inapplicable value; and an inapplicable token
remains inapplicable.
}
\examples{
trees <- inapplicable.trees[["Vinther2008"]]
dataset <- inapplicable.phyData[["Vinther2008"]]
char <- dataset[, 11]
added <- LengthAdded(trees, char)

PlotCharacter(
  tree = trees[[1]], 
  dataset = char,
  tip.color = 1 + added[trees[[1]]$tip.label] # Colour by added steps
) -> XX # Suppress return value; display plot only

}
\references{
\insertAllCited{}
}
\seealso{
Other tree scoring: 
\code{\link{CharacterLength}()},
\code{\link{IWScore}()},
\code{\link{MinimumLength}()},
\code{\link{MorphyTreeLength}()},
\code{\link{TaxonInfluence}()}
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree scoring}
