% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddTip.R
\name{AddTip}
\alias{AddTip}
\alias{AddTipEverywhere}
\title{Add a tip to a phylogenetic tree}
\usage{
AddTip(
  tree,
  where = sample.int(tree[["Nnode"]] * 2 + 2L, size = 1) - 1L,
  label = "New tip",
  edgeLength = 0,
  lengthBelow = NULL,
  nTip = NTip(tree),
  nNode = tree[["Nnode"]],
  rootNode = RootNode(tree)
)

AddTipEverywhere(tree, label = "New tip", includeRoot = FALSE)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}

\item{where}{The node or tip that should form the sister taxon to the new
node.  To add a new tip at the root, use \code{where = 0}.  By default, the
new tip is added to a random edge.}

\item{label}{Character string providing the label to apply to the new tip.}

\item{edgeLength}{Numeric specifying length of new edge}

\item{lengthBelow}{Numeric specifying length below neighbour at which to
graft new edge. Values greater than the length of the edge will result
in negative edge lengths. If \code{NULL}, the default, the new tip will be added
at the midpoint of the broken edge. If inserting at the root (\code{where = 0}),
a new edge of length \code{lengthBelow} will be inserted.}

\item{nTip, nNode, rootNode}{Optional integer vectors specifying number of tips and
nodes in \code{tree}, and index of root node.
Not checked for correctness: specifying values here trades code safety for a
nominal speed increase.}

\item{includeRoot}{Logical; if \code{TRUE}, each position adjacent
to the root edge is considered to represent distinct edges; if \code{FALSE},
they are treated as a single edge.}
}
\value{
\code{AddTip()} returns a tree of class \code{phylo} with an additional tip
at the desired location.

\code{AddTipEverywhere()} returns a list of class \code{multiPhylo} containing
the trees produced by adding \code{label} to each edge of \code{tree} in turn.
}
\description{
\code{AddTip()} adds a tip to a phylogenetic tree at a specified location.
}
\details{
\code{AddTip()} extends \code{\link{bind.tree}}, which cannot handle
single-taxon trees.

\code{AddTipEverywhere()} adds a tip to each edge in turn.
}
\examples{
plot(tree <- BalancedTree(10))
ape::nodelabels()
ape::nodelabels(15, 15, bg="green")

plot(AddTip(tree, 15, "NEW_TIP"))

oldPar <- par(mfrow = c(2, 4), mar = rep(0.3, 4), cex = 0.9)

backbone <- BalancedTree(4)
# Treating the position of the root as instructive:
additions <- AddTipEverywhere(backbone, includeRoot = TRUE)
xx <- lapply(additions, plot)

par(mfrow=c(2, 3))
# Don't treat root edges as distinct:
additions <- AddTipEverywhere(backbone, includeRoot = FALSE)
xx <- lapply(additions, plot)

par(oldPar)

}
\seealso{
Add one tree to another: \code{\link{bind.tree}()}

Other tree manipulation: 
\code{\link{CollapseNode}()},
\code{\link{ConsensusWithout}()},
\code{\link{DropTip}()},
\code{\link{EnforceOutgroup}()},
\code{\link{ImposeConstraint}()},
\code{\link{KeptPaths}()},
\code{\link{KeptVerts}()},
\code{\link{LeafLabelInterchange}()},
\code{\link{MakeTreeBinary}()},
\code{\link{RenumberTips}()},
\code{\link{RenumberTree}()},
\code{\link{Renumber}()},
\code{\link{RootTree}()},
\code{\link{SortTree}()},
\code{\link{Subtree}()},
\code{\link{TipTimedTree}()},
\code{\link{TrivialTree}}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree manipulation}
\keyword{tree}
