% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_generation.R
\name{GenerateTree}
\alias{GenerateTree}
\alias{RandomTree}
\alias{YuleTree}
\alias{PectinateTree}
\alias{BalancedTree}
\alias{StarTree}
\title{Generate pectinate, balanced or random trees}
\usage{
RandomTree(tips, root = FALSE, nodes, lengths = NULL)

YuleTree(tips, addInTurn = FALSE, root = TRUE, lengths = NULL)

PectinateTree(tips, lengths = NULL)

BalancedTree(tips, lengths = NULL)

StarTree(tips, lengths = NULL)
}
\arguments{
\item{tips}{An integer specifying the number of tips, or a character vector
naming the tips, or any other object from which \code{\link[=TipLabels]{TipLabels()}} can
extract leaf labels.}

\item{root}{Character or integer specifying tip to use as root;
or \code{TRUE} to root the tree on a random edge;
or \code{FALSE} to return an unrooted tree.}

\item{nodes}{Number of nodes to generate.  The default and maximum,
\code{tips - 1}, generates a binary tree; setting a lower value will induce
polytomies.}

\item{lengths}{a numeric vector specifying the edge lengths of the tree.}

\item{addInTurn}{Logical specifying whether to add leaves in the order of
\code{tips}.  If \code{FALSE}, leaves will be added in a random order.}
}
\value{
Each function returns an unweighted binary tree of class \code{phylo} with
the specified leaf labels. Trees are rooted unless \code{root = FALSE}.

\code{RandomTree()} returns a topology drawn at random from the uniform
distribution (i.e. each binary tree is drawn with equal probability).
Trees are generated by inserting
each tip in term at a randomly selected edge in the tree.
Random numbers are generated using a Mersenne Twister.
If \code{root = FALSE}, the tree will be unrooted, with the first tip in a
basal position.  Otherwise, the tree will be rooted on \code{root}.

\code{YuleTree()} returns a topology generated by the Yule process
\insertCite{Steel2001}{TreeTools},
i.e. adding leaves in turn adjacent to a randomly-chosen existing leaf.

\code{PectinateTree()} returns a pectinate (caterpillar) tree.

\code{BalancedTree()} returns a balanced (symmetrical) tree, in preorder.

\code{StarTree()} returns a completely unresolved (star) tree.
}
\description{
\code{RandomTree()}, \code{PectinateTree()}, \code{BalancedTree()} and \code{StarTree()}
generate trees with the specified shapes and leaf labels.
}
\examples{
RandomTree(LETTERS[1:10])

data("Lobo")
RandomTree(Lobo.phy)

YuleTree(LETTERS[1:10])

plot(PectinateTree(LETTERS[1:10]))

plot(BalancedTree(LETTERS[1:10]))
plot(StarTree(LETTERS[1:10]))

}
\references{
\insertAllCited()
}
\seealso{
Other tree generation functions: 
\code{\link{ConstrainedNJ}()},
\code{\link{NJTree}()},
\code{\link{TreeNumber}},
\code{\link{TrivialTree}}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree generation functions}
