// Generated by rstantools.  Do not edit by hand.

/*
    TriDimRegression is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    TriDimRegression is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with TriDimRegression.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_tridim_transformation_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_tridim_transformation");
    reader.add_event(159, 157, "end", "model_tridim_transformation");
    return reader;
}
#include <stan_meta_header.hpp>
class model_tridim_transformation
  : public stan::model::model_base_crtp<model_tridim_transformation> {
private:
        int transform;
        int rowsN;
        int varsN;
        int betaN;
        matrix_d dv;
        matrix_d iv;
        vector_d dv_sd;
        std::vector<double> a_prior;
        std::vector<double> b_prior;
        double sigma_prior;
        int longN;
        int TRANSLATION;
        int EUCLIDEAN;
        int AFFINE;
        int PROJECTIVE;
        int EUCLIDEAN_X;
        int EUCLIDEAN_y;
        int EUCLIDEAN_z;
        vector_d dv_long;
        vector_d iv_long;
        vector_d dv_sd_long;
        matrix_d ivH;
public:
    model_tridim_transformation(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_tridim_transformation(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_tridim_transformation_namespace::model_tridim_transformation";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "transform", "int", context__.to_vec());
            transform = int(0);
            vals_i__ = context__.vals_i("transform");
            pos__ = 0;
            transform = vals_i__[pos__++];
            check_greater_or_equal(function__, "transform", transform, 0);
            check_less_or_equal(function__, "transform", transform, 6);
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "rowsN", "int", context__.to_vec());
            rowsN = int(0);
            vals_i__ = context__.vals_i("rowsN");
            pos__ = 0;
            rowsN = vals_i__[pos__++];
            check_greater_or_equal(function__, "rowsN", rowsN, 1);
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "varsN", "int", context__.to_vec());
            varsN = int(0);
            vals_i__ = context__.vals_i("varsN");
            pos__ = 0;
            varsN = vals_i__[pos__++];
            check_greater_or_equal(function__, "varsN", varsN, 1);
            current_statement_begin__ = 6;
            context__.validate_dims("data initialization", "betaN", "int", context__.to_vec());
            betaN = int(0);
            vals_i__ = context__.vals_i("betaN");
            pos__ = 0;
            betaN = vals_i__[pos__++];
            check_greater_or_equal(function__, "betaN", betaN, 0);
            current_statement_begin__ = 7;
            validate_non_negative_index("dv", "rowsN", rowsN);
            validate_non_negative_index("dv", "varsN", varsN);
            context__.validate_dims("data initialization", "dv", "matrix_d", context__.to_vec(rowsN,varsN));
            dv = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(rowsN, varsN);
            vals_r__ = context__.vals_r("dv");
            pos__ = 0;
            size_t dv_j_2_max__ = varsN;
            size_t dv_j_1_max__ = rowsN;
            for (size_t j_2__ = 0; j_2__ < dv_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < dv_j_1_max__; ++j_1__) {
                    dv(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 8;
            validate_non_negative_index("iv", "rowsN", rowsN);
            validate_non_negative_index("iv", "varsN", varsN);
            context__.validate_dims("data initialization", "iv", "matrix_d", context__.to_vec(rowsN,varsN));
            iv = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(rowsN, varsN);
            vals_r__ = context__.vals_r("iv");
            pos__ = 0;
            size_t iv_j_2_max__ = varsN;
            size_t iv_j_1_max__ = rowsN;
            for (size_t j_2__ = 0; j_2__ < iv_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < iv_j_1_max__; ++j_1__) {
                    iv(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 9;
            validate_non_negative_index("dv_sd", "varsN", varsN);
            context__.validate_dims("data initialization", "dv_sd", "vector_d", context__.to_vec(varsN));
            dv_sd = Eigen::Matrix<double, Eigen::Dynamic, 1>(varsN);
            vals_r__ = context__.vals_r("dv_sd");
            pos__ = 0;
            size_t dv_sd_j_1_max__ = varsN;
            for (size_t j_1__ = 0; j_1__ < dv_sd_j_1_max__; ++j_1__) {
                dv_sd(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "dv_sd", dv_sd, 0);
            current_statement_begin__ = 12;
            validate_non_negative_index("a_prior", "2", 2);
            context__.validate_dims("data initialization", "a_prior", "double", context__.to_vec(2));
            a_prior = std::vector<double>(2, double(0));
            vals_r__ = context__.vals_r("a_prior");
            pos__ = 0;
            size_t a_prior_k_0_max__ = 2;
            for (size_t k_0__ = 0; k_0__ < a_prior_k_0_max__; ++k_0__) {
                a_prior[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 13;
            validate_non_negative_index("b_prior", "2", 2);
            context__.validate_dims("data initialization", "b_prior", "double", context__.to_vec(2));
            b_prior = std::vector<double>(2, double(0));
            vals_r__ = context__.vals_r("b_prior");
            pos__ = 0;
            size_t b_prior_k_0_max__ = 2;
            for (size_t k_0__ = 0; k_0__ < b_prior_k_0_max__; ++k_0__) {
                b_prior[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 14;
            context__.validate_dims("data initialization", "sigma_prior", "double", context__.to_vec());
            sigma_prior = double(0);
            vals_r__ = context__.vals_r("sigma_prior");
            pos__ = 0;
            sigma_prior = vals_r__[pos__++];
            check_greater_or_equal(function__, "sigma_prior", sigma_prior, 0);
            // initialize transformed data variables
            current_statement_begin__ = 17;
            longN = int(0);
            stan::math::fill(longN, std::numeric_limits<int>::min());
            stan::math::assign(longN,(rowsN * varsN));
            current_statement_begin__ = 20;
            TRANSLATION = int(0);
            stan::math::fill(TRANSLATION, std::numeric_limits<int>::min());
            stan::math::assign(TRANSLATION,0);
            current_statement_begin__ = 21;
            EUCLIDEAN = int(0);
            stan::math::fill(EUCLIDEAN, std::numeric_limits<int>::min());
            stan::math::assign(EUCLIDEAN,1);
            current_statement_begin__ = 22;
            AFFINE = int(0);
            stan::math::fill(AFFINE, std::numeric_limits<int>::min());
            stan::math::assign(AFFINE,2);
            current_statement_begin__ = 23;
            PROJECTIVE = int(0);
            stan::math::fill(PROJECTIVE, std::numeric_limits<int>::min());
            stan::math::assign(PROJECTIVE,3);
            current_statement_begin__ = 24;
            EUCLIDEAN_X = int(0);
            stan::math::fill(EUCLIDEAN_X, std::numeric_limits<int>::min());
            stan::math::assign(EUCLIDEAN_X,4);
            current_statement_begin__ = 25;
            EUCLIDEAN_y = int(0);
            stan::math::fill(EUCLIDEAN_y, std::numeric_limits<int>::min());
            stan::math::assign(EUCLIDEAN_y,5);
            current_statement_begin__ = 26;
            EUCLIDEAN_z = int(0);
            stan::math::fill(EUCLIDEAN_z, std::numeric_limits<int>::min());
            stan::math::assign(EUCLIDEAN_z,6);
            current_statement_begin__ = 29;
            validate_non_negative_index("dv_long", "longN", longN);
            dv_long = Eigen::Matrix<double, Eigen::Dynamic, 1>(longN);
            stan::math::fill(dv_long, DUMMY_VAR__);
            current_statement_begin__ = 30;
            validate_non_negative_index("iv_long", "longN", longN);
            iv_long = Eigen::Matrix<double, Eigen::Dynamic, 1>(longN);
            stan::math::fill(iv_long, DUMMY_VAR__);
            current_statement_begin__ = 31;
            validate_non_negative_index("dv_sd_long", "longN", longN);
            dv_sd_long = Eigen::Matrix<double, Eigen::Dynamic, 1>(longN);
            stan::math::fill(dv_sd_long, DUMMY_VAR__);
            current_statement_begin__ = 34;
            validate_non_negative_index("ivH", "rowsN", rowsN);
            validate_non_negative_index("ivH", "(varsN + 1)", (varsN + 1));
            ivH = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(rowsN, (varsN + 1));
            stan::math::fill(ivH, DUMMY_VAR__);
            // execute transformed data statements
            current_statement_begin__ = 37;
            stan::math::assign(dv_long, to_vector(dv));
            current_statement_begin__ = 38;
            stan::math::assign(iv_long, to_vector(iv));
            current_statement_begin__ = 39;
            stan::math::assign(dv_sd_long, to_vector(rep_matrix(dv_sd, rowsN)));
            current_statement_begin__ = 42;
            for (int iR = 1; iR <= rowsN; ++iR) {
                current_statement_begin__ = 43;
                for (int iV = 1; iV <= varsN; ++iV) {
                    current_statement_begin__ = 44;
                    stan::model::assign(ivH, 
                                stan::model::cons_list(stan::model::index_uni(iR), stan::model::cons_list(stan::model::index_uni(iV), stan::model::nil_index_list())), 
                                get_base1(iv, iR, iV, "iv", 1), 
                                "assigning variable ivH");
                }
                current_statement_begin__ = 46;
                stan::model::assign(ivH, 
                            stan::model::cons_list(stan::model::index_uni(iR), stan::model::cons_list(stan::model::index_uni((varsN + 1)), stan::model::nil_index_list())), 
                            1, 
                            "assigning variable ivH");
            }
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 51;
            validate_non_negative_index("a", "varsN", varsN);
            num_params_r__ += (1 * varsN);
            current_statement_begin__ = 52;
            validate_non_negative_index("b", "betaN", betaN);
            num_params_r__ += (1 * betaN);
            current_statement_begin__ = 55;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_tridim_transformation() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 51;
        if (!(context__.contains_r("a")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable a missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("a");
        pos__ = 0U;
        validate_non_negative_index("a", "varsN", varsN);
        context__.validate_dims("parameter initialization", "a", "double", context__.to_vec(varsN));
        std::vector<double> a(varsN, double(0));
        size_t a_k_0_max__ = varsN;
        for (size_t k_0__ = 0; k_0__ < a_k_0_max__; ++k_0__) {
            a[k_0__] = vals_r__[pos__++];
        }
        size_t a_i_0_max__ = varsN;
        for (size_t i_0__ = 0; i_0__ < a_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(a[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable a: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 52;
        if (!(context__.contains_r("b")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable b missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("b");
        pos__ = 0U;
        validate_non_negative_index("b", "betaN", betaN);
        context__.validate_dims("parameter initialization", "b", "double", context__.to_vec(betaN));
        std::vector<double> b(betaN, double(0));
        size_t b_k_0_max__ = betaN;
        for (size_t k_0__ = 0; k_0__ < b_k_0_max__; ++k_0__) {
            b[k_0__] = vals_r__[pos__++];
        }
        size_t b_i_0_max__ = betaN;
        for (size_t i_0__ = 0; i_0__ < b_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(b[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable b: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 55;
        if (!(context__.contains_r("sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma", "double", context__.to_vec());
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 51;
            std::vector<local_scalar_t__> a;
            size_t a_d_0_max__ = varsN;
            a.reserve(a_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < a_d_0_max__; ++d_0__) {
                if (jacobian__)
                    a.push_back(in__.scalar_constrain(lp__));
                else
                    a.push_back(in__.scalar_constrain());
            }
            current_statement_begin__ = 52;
            std::vector<local_scalar_t__> b;
            size_t b_d_0_max__ = betaN;
            b.reserve(b_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < b_d_0_max__; ++d_0__) {
                if (jacobian__)
                    b.push_back(in__.scalar_constrain(lp__));
                else
                    b.push_back(in__.scalar_constrain());
            }
            current_statement_begin__ = 55;
            local_scalar_t__ sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.scalar_lb_constrain(0, lp__);
            else
                sigma = in__.scalar_lb_constrain(0);
            // transformed parameters
            current_statement_begin__ = 58;
            validate_non_negative_index("predicted", "longN", longN);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> predicted(longN);
            stan::math::initialize(predicted, DUMMY_VAR__);
            stan::math::fill(predicted, DUMMY_VAR__);
            current_statement_begin__ = 61;
            validate_non_negative_index("M", "(varsN + 1)", (varsN + 1));
            validate_non_negative_index("M", "(varsN + 1)", (varsN + 1));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> M((varsN + 1), (varsN + 1));
            stan::math::initialize(M, DUMMY_VAR__);
            stan::math::fill(M, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 63;
            if (as_bool(logical_eq(varsN, 2))) {
                current_statement_begin__ = 65;
                if (as_bool(logical_eq(transform, TRANSLATION))) {
                    current_statement_begin__ = 66;
                    stan::math::assign(M, stan::math::to_matrix(stan::math::array_builder<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >().add(stan::math::to_row_vector(stan::math::array_builder<double >().add(1).add(0).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<double >().add(0).add(1).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(a, 1, "a", 1)).add(get_base1(a, 2, "a", 1)).add(1).array())).array()));
                } else if (as_bool(logical_eq(transform, EUCLIDEAN))) {
                    current_statement_begin__ = 71;
                    stan::math::assign(M, stan::math::to_matrix(stan::math::array_builder<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >().add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 1, "b", 1)).add(-(get_base1(b, 2, "b", 1))).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 2, "b", 1)).add(get_base1(b, 1, "b", 1)).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(a, 1, "a", 1)).add(get_base1(a, 2, "a", 1)).add(1).array())).array()));
                } else if (as_bool(logical_eq(transform, AFFINE))) {
                    current_statement_begin__ = 76;
                    stan::math::assign(M, stan::math::to_matrix(stan::math::array_builder<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >().add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 1, "b", 1)).add(get_base1(b, 3, "b", 1)).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 2, "b", 1)).add(get_base1(b, 4, "b", 1)).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(a, 1, "a", 1)).add(get_base1(a, 2, "a", 1)).add(1).array())).array()));
                } else if (as_bool(logical_eq(transform, PROJECTIVE))) {
                    current_statement_begin__ = 81;
                    stan::math::assign(M, stan::math::to_matrix(stan::math::array_builder<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >().add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 1, "b", 1)).add(get_base1(b, 3, "b", 1)).add(get_base1(b, 5, "b", 1)).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 2, "b", 1)).add(get_base1(b, 4, "b", 1)).add(get_base1(b, 6, "b", 1)).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(a, 1, "a", 1)).add(get_base1(a, 2, "a", 1)).add(1).array())).array()));
                }
            } else {
                current_statement_begin__ = 88;
                if (as_bool(logical_eq(transform, TRANSLATION))) {
                    current_statement_begin__ = 89;
                    stan::math::assign(M, stan::math::to_matrix(stan::math::array_builder<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >().add(stan::math::to_row_vector(stan::math::array_builder<double >().add(1).add(0).add(0).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<double >().add(0).add(1).add(0).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<double >().add(0).add(0).add(1).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(a, 1, "a", 1)).add(get_base1(a, 2, "a", 1)).add(get_base1(a, 3, "a", 1)).add(1).array())).array()));
                } else if (as_bool(logical_eq(transform, EUCLIDEAN_X))) {
                    {
                    current_statement_begin__ = 95;
                    local_scalar_t__ phi(DUMMY_VAR__);
                    (void) phi;  // dummy to suppress unused var warning
                    stan::math::initialize(phi, DUMMY_VAR__);
                    stan::math::fill(phi, DUMMY_VAR__);
                    current_statement_begin__ = 96;
                    stan::math::assign(phi, stan::math::sqrt(((get_base1(b, 1, "b", 1) * get_base1(b, 1, "b", 1)) + (get_base1(b, 2, "b", 1) * get_base1(b, 2, "b", 1)))));
                    current_statement_begin__ = 98;
                    stan::math::assign(M, stan::math::to_matrix(stan::math::array_builder<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >().add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(phi).add(0).add(0).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(0).add(get_base1(b, 1, "b", 1)).add(get_base1(b, 2, "b", 1)).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(0).add(-(get_base1(b, 2, "b", 1))).add(get_base1(b, 1, "b", 1)).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(a, 1, "a", 1)).add(get_base1(a, 2, "a", 1)).add(get_base1(a, 3, "a", 1)).add(1).array())).array()));
                    }
                } else if (as_bool(logical_eq(transform, EUCLIDEAN_y))) {
                    {
                    current_statement_begin__ = 104;
                    local_scalar_t__ phi(DUMMY_VAR__);
                    (void) phi;  // dummy to suppress unused var warning
                    stan::math::initialize(phi, DUMMY_VAR__);
                    stan::math::fill(phi, DUMMY_VAR__);
                    current_statement_begin__ = 105;
                    stan::math::assign(phi, stan::math::sqrt(((get_base1(b, 1, "b", 1) * get_base1(b, 1, "b", 1)) + (get_base1(b, 2, "b", 1) * get_base1(b, 2, "b", 1)))));
                    current_statement_begin__ = 107;
                    stan::math::assign(M, stan::math::to_matrix(stan::math::array_builder<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >().add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 1, "b", 1)).add(0).add(-(get_base1(b, 2, "b", 1))).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(0).add(phi).add(0).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 2, "b", 1)).add(0).add(get_base1(b, 1, "b", 1)).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(a, 1, "a", 1)).add(get_base1(a, 2, "a", 1)).add(get_base1(a, 3, "a", 1)).add(1).array())).array()));
                    }
                } else if (as_bool(logical_eq(transform, EUCLIDEAN_z))) {
                    {
                    current_statement_begin__ = 113;
                    local_scalar_t__ phi(DUMMY_VAR__);
                    (void) phi;  // dummy to suppress unused var warning
                    stan::math::initialize(phi, DUMMY_VAR__);
                    stan::math::fill(phi, DUMMY_VAR__);
                    current_statement_begin__ = 114;
                    stan::math::assign(phi, stan::math::sqrt(((get_base1(b, 1, "b", 1) * get_base1(b, 1, "b", 1)) + (get_base1(b, 2, "b", 1) * get_base1(b, 2, "b", 1)))));
                    current_statement_begin__ = 116;
                    stan::math::assign(M, stan::math::to_matrix(stan::math::array_builder<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >().add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 1, "b", 1)).add(get_base1(b, 2, "b", 1)).add(0).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(-(get_base1(b, 2, "b", 1))).add(get_base1(b, 1, "b", 1)).add(0).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(0).add(0).add(phi).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(a, 1, "a", 1)).add(get_base1(a, 2, "a", 1)).add(get_base1(a, 3, "a", 1)).add(1).array())).array()));
                    }
                } else if (as_bool(logical_eq(transform, AFFINE))) {
                    current_statement_begin__ = 122;
                    stan::math::assign(M, stan::math::to_matrix(stan::math::array_builder<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >().add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 1, "b", 1)).add(get_base1(b, 4, "b", 1)).add(get_base1(b, 7, "b", 1)).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 2, "b", 1)).add(get_base1(b, 5, "b", 1)).add(get_base1(b, 8, "b", 1)).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 3, "b", 1)).add(get_base1(b, 6, "b", 1)).add(get_base1(b, 9, "b", 1)).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(a, 1, "a", 1)).add(get_base1(a, 2, "a", 1)).add(get_base1(a, 3, "a", 1)).add(1).array())).array()));
                } else if (as_bool(logical_eq(transform, PROJECTIVE))) {
                    current_statement_begin__ = 128;
                    stan::math::assign(M, stan::math::to_matrix(stan::math::array_builder<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >().add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 1, "b", 1)).add(get_base1(b, 4, "b", 1)).add(get_base1(b, 7, "b", 1)).add(get_base1(b, 10, "b", 1)).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 2, "b", 1)).add(get_base1(b, 5, "b", 1)).add(get_base1(b, 8, "b", 1)).add(get_base1(b, 11, "b", 1)).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 3, "b", 1)).add(get_base1(b, 6, "b", 1)).add(get_base1(b, 9, "b", 1)).add(get_base1(b, 12, "b", 1)).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(a, 1, "a", 1)).add(get_base1(a, 2, "a", 1)).add(get_base1(a, 3, "a", 1)).add(1).array())).array()));
                }
            }
            current_statement_begin__ = 136;
            stan::math::assign(predicted, to_vector(block(multiply(ivH, M), 1, 1, rowsN, varsN)));
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 58;
            size_t predicted_j_1_max__ = longN;
            for (size_t j_1__ = 0; j_1__ < predicted_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(predicted(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: predicted" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable predicted: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 61;
            size_t M_j_1_max__ = (varsN + 1);
            size_t M_j_2_max__ = (varsN + 1);
            for (size_t j_1__ = 0; j_1__ < M_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < M_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(M(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: M" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable M: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            // model body
            current_statement_begin__ = 140;
            lp_accum__.add(normal_log<propto__>(dv_long, predicted, elt_multiply(dv_sd_long, rep_vector(sigma, longN))));
            current_statement_begin__ = 143;
            lp_accum__.add(exponential_log<propto__>(sigma, sigma_prior));
            current_statement_begin__ = 144;
            lp_accum__.add(normal_log<propto__>(a, get_base1(a_prior, 1, "a_prior", 1), get_base1(a_prior, 2, "a_prior", 1)));
            current_statement_begin__ = 145;
            if (as_bool(logical_neq(transform, TRANSLATION))) {
                current_statement_begin__ = 146;
                lp_accum__.add(normal_log<propto__>(b, get_base1(b_prior, 1, "b_prior", 1), get_base1(b_prior, 2, "b_prior", 1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("a");
        names__.push_back("b");
        names__.push_back("sigma");
        names__.push_back("predicted");
        names__.push_back("M");
        names__.push_back("log_lik");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(varsN);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(betaN);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(longN);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((varsN + 1));
        dims__.push_back((varsN + 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(rowsN);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_tridim_transformation_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        std::vector<double> a;
        size_t a_d_0_max__ = varsN;
        a.reserve(a_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < a_d_0_max__; ++d_0__) {
            a.push_back(in__.scalar_constrain());
        }
        size_t a_k_0_max__ = varsN;
        for (size_t k_0__ = 0; k_0__ < a_k_0_max__; ++k_0__) {
            vars__.push_back(a[k_0__]);
        }
        std::vector<double> b;
        size_t b_d_0_max__ = betaN;
        b.reserve(b_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < b_d_0_max__; ++d_0__) {
            b.push_back(in__.scalar_constrain());
        }
        size_t b_k_0_max__ = betaN;
        for (size_t k_0__ = 0; k_0__ < b_k_0_max__; ++k_0__) {
            vars__.push_back(b[k_0__]);
        }
        double sigma = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 58;
            validate_non_negative_index("predicted", "longN", longN);
            Eigen::Matrix<double, Eigen::Dynamic, 1> predicted(longN);
            stan::math::initialize(predicted, DUMMY_VAR__);
            stan::math::fill(predicted, DUMMY_VAR__);
            current_statement_begin__ = 61;
            validate_non_negative_index("M", "(varsN + 1)", (varsN + 1));
            validate_non_negative_index("M", "(varsN + 1)", (varsN + 1));
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> M((varsN + 1), (varsN + 1));
            stan::math::initialize(M, DUMMY_VAR__);
            stan::math::fill(M, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 63;
            if (as_bool(logical_eq(varsN, 2))) {
                current_statement_begin__ = 65;
                if (as_bool(logical_eq(transform, TRANSLATION))) {
                    current_statement_begin__ = 66;
                    stan::math::assign(M, stan::math::to_matrix(stan::math::array_builder<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >().add(stan::math::to_row_vector(stan::math::array_builder<double >().add(1).add(0).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<double >().add(0).add(1).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(a, 1, "a", 1)).add(get_base1(a, 2, "a", 1)).add(1).array())).array()));
                } else if (as_bool(logical_eq(transform, EUCLIDEAN))) {
                    current_statement_begin__ = 71;
                    stan::math::assign(M, stan::math::to_matrix(stan::math::array_builder<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >().add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 1, "b", 1)).add(-(get_base1(b, 2, "b", 1))).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 2, "b", 1)).add(get_base1(b, 1, "b", 1)).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(a, 1, "a", 1)).add(get_base1(a, 2, "a", 1)).add(1).array())).array()));
                } else if (as_bool(logical_eq(transform, AFFINE))) {
                    current_statement_begin__ = 76;
                    stan::math::assign(M, stan::math::to_matrix(stan::math::array_builder<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >().add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 1, "b", 1)).add(get_base1(b, 3, "b", 1)).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 2, "b", 1)).add(get_base1(b, 4, "b", 1)).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(a, 1, "a", 1)).add(get_base1(a, 2, "a", 1)).add(1).array())).array()));
                } else if (as_bool(logical_eq(transform, PROJECTIVE))) {
                    current_statement_begin__ = 81;
                    stan::math::assign(M, stan::math::to_matrix(stan::math::array_builder<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >().add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 1, "b", 1)).add(get_base1(b, 3, "b", 1)).add(get_base1(b, 5, "b", 1)).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 2, "b", 1)).add(get_base1(b, 4, "b", 1)).add(get_base1(b, 6, "b", 1)).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(a, 1, "a", 1)).add(get_base1(a, 2, "a", 1)).add(1).array())).array()));
                }
            } else {
                current_statement_begin__ = 88;
                if (as_bool(logical_eq(transform, TRANSLATION))) {
                    current_statement_begin__ = 89;
                    stan::math::assign(M, stan::math::to_matrix(stan::math::array_builder<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >().add(stan::math::to_row_vector(stan::math::array_builder<double >().add(1).add(0).add(0).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<double >().add(0).add(1).add(0).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<double >().add(0).add(0).add(1).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(a, 1, "a", 1)).add(get_base1(a, 2, "a", 1)).add(get_base1(a, 3, "a", 1)).add(1).array())).array()));
                } else if (as_bool(logical_eq(transform, EUCLIDEAN_X))) {
                    {
                    current_statement_begin__ = 95;
                    local_scalar_t__ phi(DUMMY_VAR__);
                    (void) phi;  // dummy to suppress unused var warning
                    stan::math::initialize(phi, DUMMY_VAR__);
                    stan::math::fill(phi, DUMMY_VAR__);
                    current_statement_begin__ = 96;
                    stan::math::assign(phi, stan::math::sqrt(((get_base1(b, 1, "b", 1) * get_base1(b, 1, "b", 1)) + (get_base1(b, 2, "b", 1) * get_base1(b, 2, "b", 1)))));
                    current_statement_begin__ = 98;
                    stan::math::assign(M, stan::math::to_matrix(stan::math::array_builder<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >().add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(phi).add(0).add(0).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(0).add(get_base1(b, 1, "b", 1)).add(get_base1(b, 2, "b", 1)).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(0).add(-(get_base1(b, 2, "b", 1))).add(get_base1(b, 1, "b", 1)).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(a, 1, "a", 1)).add(get_base1(a, 2, "a", 1)).add(get_base1(a, 3, "a", 1)).add(1).array())).array()));
                    }
                } else if (as_bool(logical_eq(transform, EUCLIDEAN_y))) {
                    {
                    current_statement_begin__ = 104;
                    local_scalar_t__ phi(DUMMY_VAR__);
                    (void) phi;  // dummy to suppress unused var warning
                    stan::math::initialize(phi, DUMMY_VAR__);
                    stan::math::fill(phi, DUMMY_VAR__);
                    current_statement_begin__ = 105;
                    stan::math::assign(phi, stan::math::sqrt(((get_base1(b, 1, "b", 1) * get_base1(b, 1, "b", 1)) + (get_base1(b, 2, "b", 1) * get_base1(b, 2, "b", 1)))));
                    current_statement_begin__ = 107;
                    stan::math::assign(M, stan::math::to_matrix(stan::math::array_builder<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >().add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 1, "b", 1)).add(0).add(-(get_base1(b, 2, "b", 1))).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(0).add(phi).add(0).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 2, "b", 1)).add(0).add(get_base1(b, 1, "b", 1)).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(a, 1, "a", 1)).add(get_base1(a, 2, "a", 1)).add(get_base1(a, 3, "a", 1)).add(1).array())).array()));
                    }
                } else if (as_bool(logical_eq(transform, EUCLIDEAN_z))) {
                    {
                    current_statement_begin__ = 113;
                    local_scalar_t__ phi(DUMMY_VAR__);
                    (void) phi;  // dummy to suppress unused var warning
                    stan::math::initialize(phi, DUMMY_VAR__);
                    stan::math::fill(phi, DUMMY_VAR__);
                    current_statement_begin__ = 114;
                    stan::math::assign(phi, stan::math::sqrt(((get_base1(b, 1, "b", 1) * get_base1(b, 1, "b", 1)) + (get_base1(b, 2, "b", 1) * get_base1(b, 2, "b", 1)))));
                    current_statement_begin__ = 116;
                    stan::math::assign(M, stan::math::to_matrix(stan::math::array_builder<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >().add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 1, "b", 1)).add(get_base1(b, 2, "b", 1)).add(0).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(-(get_base1(b, 2, "b", 1))).add(get_base1(b, 1, "b", 1)).add(0).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(0).add(0).add(phi).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(a, 1, "a", 1)).add(get_base1(a, 2, "a", 1)).add(get_base1(a, 3, "a", 1)).add(1).array())).array()));
                    }
                } else if (as_bool(logical_eq(transform, AFFINE))) {
                    current_statement_begin__ = 122;
                    stan::math::assign(M, stan::math::to_matrix(stan::math::array_builder<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >().add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 1, "b", 1)).add(get_base1(b, 4, "b", 1)).add(get_base1(b, 7, "b", 1)).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 2, "b", 1)).add(get_base1(b, 5, "b", 1)).add(get_base1(b, 8, "b", 1)).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 3, "b", 1)).add(get_base1(b, 6, "b", 1)).add(get_base1(b, 9, "b", 1)).add(0).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(a, 1, "a", 1)).add(get_base1(a, 2, "a", 1)).add(get_base1(a, 3, "a", 1)).add(1).array())).array()));
                } else if (as_bool(logical_eq(transform, PROJECTIVE))) {
                    current_statement_begin__ = 128;
                    stan::math::assign(M, stan::math::to_matrix(stan::math::array_builder<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >().add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 1, "b", 1)).add(get_base1(b, 4, "b", 1)).add(get_base1(b, 7, "b", 1)).add(get_base1(b, 10, "b", 1)).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 2, "b", 1)).add(get_base1(b, 5, "b", 1)).add(get_base1(b, 8, "b", 1)).add(get_base1(b, 11, "b", 1)).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(b, 3, "b", 1)).add(get_base1(b, 6, "b", 1)).add(get_base1(b, 9, "b", 1)).add(get_base1(b, 12, "b", 1)).array())).add(stan::math::to_row_vector(stan::math::array_builder<local_scalar_t__ >().add(get_base1(a, 1, "a", 1)).add(get_base1(a, 2, "a", 1)).add(get_base1(a, 3, "a", 1)).add(1).array())).array()));
                }
            }
            current_statement_begin__ = 136;
            stan::math::assign(predicted, to_vector(block(multiply(ivH, M), 1, 1, rowsN, varsN)));
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t predicted_j_1_max__ = longN;
                for (size_t j_1__ = 0; j_1__ < predicted_j_1_max__; ++j_1__) {
                    vars__.push_back(predicted(j_1__));
                }
                size_t M_j_2_max__ = (varsN + 1);
                size_t M_j_1_max__ = (varsN + 1);
                for (size_t j_2__ = 0; j_2__ < M_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < M_j_1_max__; ++j_1__) {
                        vars__.push_back(M(j_1__, j_2__));
                    }
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 150;
            validate_non_negative_index("log_lik", "rowsN", rowsN);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(rowsN);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 151;
            for (int iR = 1; iR <= rowsN; ++iR) {
                current_statement_begin__ = 152;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(iR), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable log_lik");
                current_statement_begin__ = 153;
                for (int iV = 1; iV <= varsN; ++iV) {
                    current_statement_begin__ = 154;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(iR), stan::model::nil_index_list()), 
                                (stan::model::rvalue(log_lik, stan::model::cons_list(stan::model::index_uni(iR), stan::model::nil_index_list()), "log_lik") + normal_log(get_base1(dv, iR, iV, "dv", 1), get_base1(predicted, (((iR - 1) * varsN) + iV), "predicted", 1), (sigma * get_base1(dv_sd, iV, "dv_sd", 1)))), 
                                "assigning variable log_lik");
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 150;
            size_t log_lik_j_1_max__ = rowsN;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_tridim_transformation";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t a_k_0_max__ = varsN;
        for (size_t k_0__ = 0; k_0__ < a_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "a" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t b_k_0_max__ = betaN;
        for (size_t k_0__ = 0; k_0__ < b_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t predicted_j_1_max__ = longN;
            for (size_t j_1__ = 0; j_1__ < predicted_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "predicted" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t M_j_2_max__ = (varsN + 1);
            size_t M_j_1_max__ = (varsN + 1);
            for (size_t j_2__ = 0; j_2__ < M_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < M_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "M" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = rowsN;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t a_k_0_max__ = varsN;
        for (size_t k_0__ = 0; k_0__ < a_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "a" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t b_k_0_max__ = betaN;
        for (size_t k_0__ = 0; k_0__ < b_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t predicted_j_1_max__ = longN;
            for (size_t j_1__ = 0; j_1__ < predicted_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "predicted" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t M_j_2_max__ = (varsN + 1);
            size_t M_j_1_max__ = (varsN + 1);
            for (size_t j_2__ = 0; j_2__ < M_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < M_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "M" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = rowsN;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_tridim_transformation_namespace::model_tridim_transformation stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
