% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Listeners.R
\docType{class}
\name{Listeners}
\alias{Listeners}
\title{Class of Listener}
\description{
Create a class of listener. A listener monitors the trial while checking
condition of pre-defined milestones. Actions are triggered and executed
automatically.
}
\examples{
##
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Listeners-new}{\code{Listeners$new()}}
\item \href{#method-Listeners-add_milestones}{\code{Listeners$add_milestones()}}
\item \href{#method-Listeners-get_milestones}{\code{Listeners$get_milestones()}}
\item \href{#method-Listeners-get_milestone_names}{\code{Listeners$get_milestone_names()}}
\item \href{#method-Listeners-monitor}{\code{Listeners$monitor()}}
\item \href{#method-Listeners-mute}{\code{Listeners$mute()}}
\item \href{#method-Listeners-reset}{\code{Listeners$reset()}}
\item \href{#method-Listeners-clone}{\code{Listeners$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Listeners-new"></a>}}
\if{latex}{\out{\hypertarget{method-Listeners-new}{}}}
\subsection{Method \code{new()}}{
initialize a listener
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Listeners$new(silent = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{silent}}{logical. \code{TRUE} to mute messages.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Listeners-add_milestones"></a>}}
\if{latex}{\out{\hypertarget{method-Listeners-add_milestones}{}}}
\subsection{Method \code{add_milestones()}}{
register milestones with listener. Order in \code{...} matter
as they are scanned in that order. It is user's responsibility
to use reasonable order when calling this function, otherwise,
the result of \code{Listener$monitor()} can be problematic.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Listeners$add_milestones(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{milestones}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Listeners-get_milestones"></a>}}
\if{latex}{\out{\hypertarget{method-Listeners-get_milestones}{}}}
\subsection{Method \code{get_milestones()}}{
return registered milestones
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Listeners$get_milestones(milestone_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{milestone_name}}{return \code{Milestone} object with given name(s).
If \code{NULL}, all registered milestones are returned.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Listeners-get_milestone_names"></a>}}
\if{latex}{\out{\hypertarget{method-Listeners-get_milestone_names}{}}}
\subsection{Method \code{get_milestone_names()}}{
return names of registered milestones
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Listeners$get_milestone_names()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Listeners-monitor"></a>}}
\if{latex}{\out{\hypertarget{method-Listeners-monitor}{}}}
\subsection{Method \code{monitor()}}{
scan, check, and trigger registered milestones.
Milestones are triggered in the order when calling
\code{Listener$add_milestones}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Listeners$monitor(trial, dry_run)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{trial}}{a \code{Trial} object.}

\item{\code{dry_run}}{logical. See \code{Controller::run} for more information.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Listeners-mute"></a>}}
\if{latex}{\out{\hypertarget{method-Listeners-mute}{}}}
\subsection{Method \code{mute()}}{
mute all messages (not including warnings)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Listeners$mute(silent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{silent}}{logical.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Listeners-reset"></a>}}
\if{latex}{\out{\hypertarget{method-Listeners-reset}{}}}
\subsection{Method \code{reset()}}{
reset all milestones registered to the listener. Usually, this is called
before a controller can run additional replicates of simulation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Listeners$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Listeners-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Listeners-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Listeners$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
