% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmvt.R
\name{ptmvt}
\alias{ptmvt}
\title{Cumulative distribution function of the truncated multivariate Student distribution.}
\usage{
ptmvt(q, mu, sigma, df, lb, ub, type = c("mc", "qmc"), log = FALSE,
  B = 10000)
}
\arguments{
\item{q}{vector or matrix of quantiles}

\item{mu}{vector of location parameters}

\item{sigma}{scale matrix}

\item{df}{degrees of freedom}

\item{lb}{vector of lower truncation limits}

\item{ub}{vector of upper truncation limits}

\item{type}{string, either of \code{mc} or \code{qmc} for Monte Carlo and quasi Monte Carlo, respectively}

\item{log}{logical; if \code{TRUE}, probabilites and density are given on the log scale.}

\item{B}{number of replications for the (quasi)-Monte Carlo scheme}
}
\description{
This function returns the (log)-distribution function of a matrix \code{q} of observations lying in the interval [\code{lb}, \code{ub}].
}
\seealso{
\code{\link{tmvt}}
}
\keyword{internal}
