% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoPhaseDesign.R
\name{TwoPhaseDesign}
\alias{TwoPhaseDesign}
\title{Construct Two-Phase Experimental Designs with Correlated Errors}
\usage{
TwoPhaseDesign(v, rho, plot = TRUE, n_table = 10, tol = 0.001)
}
\arguments{
\item{v}{Integer (greater than or equal to 3). Number of treatments in Phase II.}

\item{rho}{Intra-block correlation coefficient. A numeric value in (-1, 1).}

\item{plot}{Logical. If TRUE, plots Efficiency Factor vs Intra-block correlation coefficient.}

\item{n_table}{Number of efficiency values to display in the output table.}

\item{tol}{Tolerance level for classifying Efficiency Factor as approximately equal to 1. Default is 1e-3.}
}
\value{
A list with design layouts, component information matrices, efficiency plot, summary efficiency table, and filtered efficiency table.
}
\description{
Constructs a two-phase experimental design, computes component information matrices, and evaluates the efficiency factor across intra-block correlations values.
}
\examples{
result <- TwoPhaseDesign(v = 4, rho = 0.25, plot = FALSE)
print(result$eff_summary)

}
\references{
McIntyre, G. A. (1955). Design and analysis of two-phase experiments. \emph{Biometrics}, 11(3), 324-334.
<doi:10.2307/3001770>
}
