% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IMU_ActiGraph_Scripts.R
\name{get_cvPER}
\alias{get_cvPER}
\title{Calculate coefficient of variation in sliding windows}
\usage{
get_cvPER(big_data, window_secs = 10, Algorithm, verbose = FALSE)
}
\arguments{
\item{big_data}{a numeric vector on which to perform the calculation}

\item{window_secs}{size of the sliding window, in seconds}

\item{Algorithm}{A numeric vector giving the algorithm(s) to apply to the data from the primary accelerometer and (if applicable) IMU}

\item{verbose}{A logical scalar: print progress updates?}
}
\value{
a numeric vector of values, giving the lowest coefficient of variation among the sliding windows that correspond to each epoch of data
}
\description{
Calculates coefficient of variation using the approach of Crouter et al. (2010, \emph{Med Sci Sports Exerc})
}
\examples{
data(raw_for_cv)
get_cvPER(raw_for_cv$ENMO, Algorithm = 1)

}
