% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCS3functions.R
\name{Forecast}
\alias{Forecast}
\title{Forecast}
\usage{
Forecast(UCompObject, level = c(80, 95), fan = FALSE)
}
\arguments{
\item{UCompObject}{UComp object}

\item{level}{Confidence level for prediction intervals}

\item{fan}{Set level to seq(51, 99, 3) when fan = TRUE}
}
\value{
An object of class \code{forecast}.

Function \code{summary} produces a summary of results, while the function \code{plot} produces a
plot of the forecast intervals.
}
\description{
Forecasting using structural Unobseved Components models
}
\details{
See help of \code{UC}.
}
\examples{
\dontrun{
y <- log(AirPassengers)
m1 <- UCmodel(y, model = "llt/eq/arma(0,0)")
f1 <- Forecast(m1)
plot(f1)
}
}
\seealso{
\code{\link{UC}}, \code{\link{UCmodel}}, \code{\link{UCvalidate}}, \code{\link{UCfilter}}, \code{\link{UCsmooth}}, 
         \code{\link{UCdisturb}}, \code{\link{UCcomponents}}
}
\author{
Diego J. Pedregal
}
